/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.engine.EngineMessages;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.listener.ListenerMap;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebResponse;

public abstract class AbstractEngine
implements IEngine {
    public static final String VISIT_CLASS_PROPERTY_NAME = "org.apache.tapestry.visit-class";
    private static final Log LOG = LogFactory.getLog(AbstractEngine.class);
    private Infrastructure _infrastructure;
    private ListenerMap _listeners;
    private Locale _locale;

    protected void activateExceptionPage(IRequestCycle cycle, Throwable cause) {
        this._infrastructure.getExceptionPresenter().presentException(cycle, cause);
    }

    public void reportException(String reportTitle, Throwable ex) {
        this._infrastructure.getRequestExceptionReporter().reportRequestException(reportTitle, ex);
    }

    protected void cleanupAfterRequest(IRequestCycle cycle) {
    }

    public Locale getLocale() {
        return this._locale;
    }

    public IEngineService getService(String name) {
        return this._infrastructure.getServiceMap().getService(name);
    }

    public IApplicationSpecification getSpecification() {
        return this._infrastructure.getApplicationSpecification();
    }

    public ISpecificationSource getSpecificationSource() {
        return this._infrastructure.getSpecificationSource();
    }

    protected void redirect(String pageName, IRequestCycle cycle, ApplicationRuntimeException exception) throws IOException {
        IPage page = cycle.getPage(pageName);
        cycle.activate(page);
        this.renderResponse(cycle);
    }

    public void renderResponse(IRequestCycle cycle) throws IOException {
        this._infrastructure.getResponseRenderer().renderResponse(cycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(WebRequest request, WebResponse response) throws IOException {
        IRequestCycle cycle = null;
        IEngineService service = null;
        if (this._infrastructure == null) {
            this._infrastructure = (Infrastructure)request.getAttribute("org.apache.tapestry.Infrastructure");
        }
        try {
            cycle = this._infrastructure.getRequestCycleFactory().newRequestCycle(this);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            service = cycle.getService();
            service.service(cycle);
            return;
        }
        catch (PageRedirectException ex) {
            this.handlePageRedirectException(cycle, ex);
        }
        catch (RedirectException ex) {
            this.handleRedirectException(cycle, ex);
        }
        catch (StaleLinkException ex) {
            this.handleStaleLinkException(cycle, ex);
        }
        catch (StaleSessionException ex) {
            this.handleStaleSessionException(cycle, ex);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Uncaught exception", (Throwable)ex);
            }
            this.activateExceptionPage(cycle, ex);
        }
        finally {
            try {
                cycle.cleanup();
                this._infrastructure.getApplicationStateManager().flush();
            }
            catch (Exception ex) {
                this.reportException(EngineMessages.exceptionDuringCleanup(ex), ex);
            }
        }
    }

    protected void handlePageRedirectException(IRequestCycle cycle, PageRedirectException exception) throws IOException {
        ArrayList<String> pageNames = new ArrayList<String>();
        String pageName = exception.getTargetPageName();
        while (true) {
            if (pageNames.contains(pageName)) {
                pageNames.add(pageName);
                throw new ApplicationRuntimeException(EngineMessages.validateCycle(pageNames));
            }
            pageNames.add(pageName);
            try {
                cycle.activate(pageName);
            }
            catch (PageRedirectException secondRedirectException) {
                pageName = secondRedirectException.getTargetPageName();
                continue;
            }
            break;
        }
        this.renderResponse(cycle);
    }

    protected void handleStaleLinkException(IRequestCycle cycle, StaleLinkException exception) throws IOException {
        this._infrastructure.getStaleLinkExceptionPresenter().presentStaleLinkException(cycle, exception);
    }

    protected void handleStaleSessionException(IRequestCycle cycle, StaleSessionException exception) throws IOException {
        this._infrastructure.getStaleSessionExceptionPresenter().presentStaleSessionException(cycle, exception);
    }

    public void setLocale(Locale value) {
        Defense.notNull((Object)value, (String)"locale");
        this._locale = value;
        if (this._infrastructure != null) {
            this._infrastructure.setLocale(value);
        }
    }

    public ClassResolver getClassResolver() {
        return this._infrastructure.getClassResolver();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("locale", (Object)this._locale);
        return builder.toString();
    }

    public Object getVisit() {
        return this._infrastructure.getApplicationStateManager().get("visit");
    }

    public void setVisit(Object visit) {
        this._infrastructure.getApplicationStateManager().store("visit", visit);
    }

    public Object getVisit(IRequestCycle cycle) {
        return this.getVisit();
    }

    public boolean getHasVisit() {
        return this._infrastructure.getApplicationStateManager().exists("visit");
    }

    public Object getGlobal() {
        return this._infrastructure.getApplicationStateManager().get("global");
    }

    public IScriptSource getScriptSource() {
        return this._infrastructure.getScriptSource();
    }

    public ListenerMap getListeners() {
        if (this._listeners == null) {
            this._listeners = this._infrastructure.getListenerMapSource().getListenerMapForObject(this);
        }
        return this._listeners;
    }

    protected void handleRedirectException(IRequestCycle cycle, RedirectException redirectException) {
        String location = redirectException.getRedirectLocation();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting to: " + location));
        }
        this._infrastructure.getRequest().forward(location);
    }

    public DataSqueezer getDataSqueezer() {
        return this._infrastructure.getDataSqueezer();
    }

    public IPropertySource getPropertySource() {
        return this._infrastructure.getApplicationPropertySource();
    }

    public Infrastructure getInfrastructure() {
        return this._infrastructure;
    }

    public String getOutputEncoding() {
        return this._infrastructure.getOutputEncoding();
    }
}

