/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.dojo.html;

import java.util.HashMap;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.dojo.DojoUtils;
import org.apache.tapestry.dojo.IWidget;
import org.apache.tapestry.dojo.html.IDojoFloatingPane;
import org.apache.tapestry.json.JSONObject;

public abstract class FloatingPane
extends AbstractComponent
implements IWidget,
IDojoFloatingPane {
    public abstract boolean getHasToolbar();

    public abstract boolean isResizable();

    public abstract boolean getPersistPosition();

    public abstract String getIdParameter();

    public abstract boolean getIsTaskBar();

    public abstract String getOptions();

    public abstract IScript getScript();

    public String getTaskBarId() {
        Object obj = this.getTaskBar();
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof FloatingPane) {
            return ((FloatingPane)obj).getIdParameter();
        }
        throw new ApplicationRuntimeException("Parameter taskBar should either be a String or a FloatingPane");
    }

    public void renderWidget(IMarkupWriter writer, IRequestCycle cycle) {
        this.renderComponent(writer, cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        writer.begin("div");
        writer.attribute("id", this.getIdParameter());
        this.renderInformalParameters(writer, cycle);
        this.renderBody(writer, cycle);
        writer.end();
        JSONObject obj = DojoUtils.parseJSONParameter(this, "options");
        obj.put("title", this.getTitle());
        if (this.getIcon() != null) {
            obj.put("iconSrc", this.getIcon().buildURL());
        }
        if (this.getHref() != null) {
            obj.put("href", this.getHref());
        }
        obj.put("widgetId", this.getId());
        obj.put("toggle", "fade");
        obj.put("constrainToContainer", this.getConstrainToContainer());
        obj.put("displayMaximizeAction", this.getDisplayMaximizeAction());
        obj.put("displayMinimizeAction", this.getDisplayMinimizeAction());
        obj.put("displayCloseAction", this.getDisplayCloseAction());
        obj.put("hasShadow", this.getHasShadow());
        obj.put("resizable", this.isResizable());
        obj.put("taskBarId", this.getTaskBarId());
        HashMap<String, String> scriptParms = new HashMap<String, String>();
        scriptParms.put("id", this.getIdParameter());
        scriptParms.put("props", obj.toString());
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport(cycle, this);
        this.getScript().execute(cycle, pageRenderSupport, scriptParms);
    }
}

