/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.dojo.form;

import java.util.Date;
import java.util.HashMap;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.dojo.form.AbstractFormWidget;
import org.apache.tapestry.form.TranslatedField;
import org.apache.tapestry.form.TranslatedFieldSupport;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.form.translator.DateTranslator;
import org.apache.tapestry.json.JSONObject;
import org.apache.tapestry.util.Strftime;
import org.apache.tapestry.valid.ValidatorException;

public abstract class DropdownDatePicker
extends AbstractFormWidget
implements TranslatedField {
    public abstract Date getValue();

    public abstract void setValue(Date var1);

    public abstract boolean isDisabled();

    public abstract String getIconAlt();

    protected void renderFormWidget(IMarkupWriter writer, IRequestCycle cycle) {
        DateTranslator translator = (DateTranslator)this.getTranslator();
        this.renderDelegatePrefix(writer, cycle);
        writer.begin("div");
        this.renderIdAttribute(writer, cycle);
        this.renderDelegateAttributes(writer, cycle);
        this.getValidatableFieldSupport().renderContributions(this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.end();
        this.renderDelegateSuffix(writer, cycle);
        JSONObject json = new JSONObject();
        json.put("inputId", this.getClientId());
        json.put("inputName", this.getName());
        json.put("iconAlt", this.getIconAlt());
        json.put("dateFormat", Strftime.convertToPosixFormat(translator.getPattern()));
        if (this.getValue() != null) {
            json.put("date", this.getTranslatedFieldSupport().format(this, this.getValue()));
        }
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("clientId", this.getClientId());
        parms.put("props", json.toString());
        this.getScript().execute(cycle, TapestryUtils.getPageRenderSupport(cycle, this), parms);
    }

    protected void rewindFormWidget(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        try {
            Date date = (Date)this.getTranslatedFieldSupport().parse(this, value);
            this.getValidatableFieldSupport().validate(this, writer, cycle, date);
            this.setValue(date);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired(this);
    }

    public abstract IScript getScript();

    public abstract TranslatedFieldSupport getTranslatedFieldSupport();

    public abstract ValidatableFieldSupport getValidatableFieldSupport();
}

