/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.components.IPrimaryKeyConverter;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.services.ExpressionEvaluator;

public abstract class ForBean
extends AbstractFormComponent {
    private static final char DESC_VALUE = 'V';
    private static final char DESC_PRIMARY_KEY = 'P';
    private final RepSource _completeRepSource = new CompleteRepSource();
    private final RepSource _keyExpressionRepSource = new KeyExpressionRepSource();
    private Object _value;
    private int _index;
    private boolean _rendering;

    public abstract String getElement();

    public abstract String getKeyExpression();

    public abstract IPrimaryKeyConverter getConverter();

    public abstract Object getDefaultValue();

    public abstract boolean getMatch();

    public abstract boolean getVolatile();

    public abstract DataSqueezer getDataSqueezer();

    public abstract ValueConverter getValueConverter();

    public abstract ExpressionEvaluator getExpressionEvaluator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = (IForm)cycle.getAttribute("org.apache.tapestry.Form");
        boolean cycleRewinding = cycle.isRewinding();
        if (cycleRewinding && form != null && !form.isRewinding()) {
            return;
        }
        Iterator dataSource = this.getData(cycle, form);
        if (dataSource == null) {
            return;
        }
        String element = this.getElement();
        try {
            this._index = 0;
            this._rendering = true;
            while (dataSource.hasNext()) {
                this._value = dataSource.next();
                this.updateOutputParameters();
                if (element != null) {
                    writer.begin(element);
                    this.renderInformalParameters(writer, cycle);
                }
                this.renderBody(writer, cycle);
                if (element != null) {
                    writer.end();
                }
                ++this._index;
            }
        }
        finally {
            this._rendering = false;
            this._value = null;
        }
    }

    public final Object getValue() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "value");
        }
        return this._value;
    }

    public int getIndex() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "index");
        }
        return this._index;
    }

    public boolean isDisabled() {
        return false;
    }

    protected void updateOutputParameters() {
        IBinding valueBinding;
        IBinding indexBinding = this.getBinding("index");
        if (indexBinding != null) {
            indexBinding.setObject(new Integer(this._index));
        }
        if ((valueBinding = this.getBinding("value")) != null) {
            valueBinding.setObject(this._value);
        }
    }

    protected void updatePrimaryKeysParameter(String[] stringReps) {
        IBinding primaryKeysBinding = this.getBinding("primaryKeys");
        if (primaryKeysBinding == null) {
            return;
        }
        DataSqueezer squeezer = this.getDataSqueezer();
        int repsCount = stringReps.length;
        ArrayList<Object> primaryKeys = new ArrayList<Object>(repsCount);
        for (int i = 0; i < stringReps.length; ++i) {
            String rep = stringReps[i];
            if (rep.length() == 0 || rep.charAt(0) != 'P') continue;
            Object primaryKey = squeezer.unsqueeze(rep.substring(1));
            primaryKeys.add(primaryKey);
        }
        primaryKeysBinding.setObject(primaryKeys);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
    }

    private Iterator getData(IRequestCycle cycle, IForm form) {
        if (form == null || this.getVolatile()) {
            return this.evaluateSourceIterator();
        }
        String name = form.getElementId(this);
        if (cycle.isRewinding()) {
            return this.getStoredData(cycle, name);
        }
        return this.storeSourceData(form, name);
    }

    protected Iterator getStoredData(IRequestCycle cycle, String name) {
        String[] stringReps = cycle.getParameters(name);
        if (stringReps == null) {
            return null;
        }
        this.updatePrimaryKeysParameter(stringReps);
        return new ReadSourceDataIterator(stringReps);
    }

    protected Iterator storeSourceData(IForm form, String name) {
        return new StoreSourceDataIterator(form, name, this.evaluateSourceIterator());
    }

    protected String getStringRepFromValue(Object value) {
        DataSqueezer squeezer = this.getDataSqueezer();
        Object pk = this.getPrimaryKeyFromValue(value);
        String rep = pk != null ? 'P' + squeezer.squeeze(pk) : 'V' + squeezer.squeeze(value);
        return rep;
    }

    protected Object getPrimaryKeyFromValue(Object value) {
        if (value == null) {
            return null;
        }
        Object primaryKey = this.getKeyExpressionFromValue(value);
        if (primaryKey == null) {
            primaryKey = this.getConverterFromValue(value);
        }
        return primaryKey;
    }

    protected Object getKeyExpressionFromValue(Object value) {
        String keyExpression = this.getKeyExpression();
        if (keyExpression == null) {
            return null;
        }
        Object primaryKey = this.getExpressionEvaluator().read(value, keyExpression);
        return primaryKey;
    }

    protected Object getConverterFromValue(Object value) {
        IPrimaryKeyConverter converter = this.getConverter();
        if (converter == null) {
            return null;
        }
        Object primaryKey = converter.getPrimaryKey(value);
        return primaryKey;
    }

    protected Object getValueFromStringRep(Iterator sourceIterator, Iterator fullSourceIterator, Map repToValueMap, String rep) {
        Object value = null;
        DataSqueezer squeezer = this.getDataSqueezer();
        if (rep == null || rep.length() == 0) {
            return this.getDefaultValue();
        }
        boolean match = this.getMatch();
        if (match && (value = this.findValueWithStringRep(sourceIterator, fullSourceIterator, repToValueMap, rep, this._completeRepSource)) != null) {
            return value;
        }
        char desc = rep.charAt(0);
        String squeezed = rep.substring(1);
        switch (desc) {
            case 'V': {
                value = squeezer.unsqueeze(squeezed);
                break;
            }
            case 'P': {
                IPrimaryKeyConverter converter;
                if (!match && this.getKeyExpression() != null) {
                    value = this.findValueWithStringRep(sourceIterator, fullSourceIterator, repToValueMap, rep, this._keyExpressionRepSource);
                }
                if (value != null || (converter = this.getConverter()) == null) break;
                Object pk = squeezer.unsqueeze(squeezed);
                value = converter.getValue(pk);
            }
        }
        if (value == null) {
            value = this.getDefaultValue();
        }
        return value;
    }

    protected Object findValueWithStringRep(Iterator sourceIterator, Iterator fullSourceIterator, Map repToValueMap, String rep, RepSource repSource) {
        Object value = repToValueMap.get(rep);
        if (value != null) {
            return value;
        }
        value = this.findValueWithStringRepInIterator(sourceIterator, repToValueMap, rep, repSource);
        if (value != null) {
            return value;
        }
        value = this.findValueWithStringRepInIterator(fullSourceIterator, repToValueMap, rep, repSource);
        return value;
    }

    protected Object findValueWithStringRepInIterator(Iterator it, Map repToValueMap, String rep, RepSource repSource) {
        while (it.hasNext()) {
            Object sourceValue = it.next();
            if (sourceValue == null) continue;
            String sourceRep = repSource.getStringRep(sourceValue);
            repToValueMap.put(sourceRep, sourceValue);
            if (!rep.equals(sourceRep)) continue;
            return sourceValue;
        }
        return null;
    }

    protected Iterator evaluateSourceIterator() {
        Iterator it = null;
        Object source = null;
        IBinding sourceBinding = this.getBinding("source");
        if (sourceBinding != null) {
            source = sourceBinding.getObject();
        }
        if (source != null) {
            it = (Iterator)this.getValueConverter().coerceValue(source, Iterator.class);
        }
        if (it == null) {
            it = Collections.EMPTY_LIST.iterator();
        }
        return it;
    }

    protected Iterator evaluateFullSourceIterator() {
        Iterator it = null;
        Object fullSource = null;
        IBinding fullSourceBinding = this.getBinding("fullSource");
        if (fullSourceBinding != null) {
            fullSource = fullSourceBinding.getObject();
        }
        if (fullSource != null) {
            it = (Iterator)this.getValueConverter().coerceValue(fullSource, Iterator.class);
        }
        if (it == null) {
            it = Collections.EMPTY_LIST.iterator();
        }
        return it;
    }

    protected boolean getCanTakeFocus() {
        return false;
    }

    public String getClientId() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    protected class KeyExpressionRepSource
    implements RepSource {
        protected KeyExpressionRepSource() {
        }

        public String getStringRep(Object value) {
            Object pk = ForBean.this.getKeyExpressionFromValue(value);
            return 'P' + ForBean.this.getDataSqueezer().squeeze(pk);
        }
    }

    protected class CompleteRepSource
    implements RepSource {
        protected CompleteRepSource() {
        }

        public String getStringRep(Object value) {
            return ForBean.this.getStringRepFromValue(value);
        }
    }

    protected static interface RepSource {
        public String getStringRep(Object var1);
    }

    private class StoreSourceDataIterator
    implements Iterator {
        private final IForm _form;
        private final String _name;
        private final Iterator _delegate;

        StoreSourceDataIterator(IForm form, String name, Iterator delegate) {
            this._form = form;
            this._name = name;
            this._delegate = delegate;
        }

        public boolean hasNext() {
            return this._delegate.hasNext();
        }

        public Object next() {
            Object value = this._delegate.next();
            String rep = ForBean.this.getStringRepFromValue(value);
            this._form.addHiddenValue(this._name, rep);
            return value;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    private class ReadSourceDataIterator
    implements Iterator {
        private final Iterator _sourceIterator;
        private final Iterator _fullSourceIterator;
        private final String[] _stringReps;
        private int _index;
        private final Map _repToValueMap;

        ReadSourceDataIterator(String[] stringReps) {
            this._sourceIterator = ForBean.this.evaluateSourceIterator();
            this._fullSourceIterator = ForBean.this.evaluateFullSourceIterator();
            this._index = 0;
            this._repToValueMap = new HashMap();
            this._stringReps = stringReps;
        }

        public boolean hasNext() {
            return this._index < this._stringReps.length;
        }

        public Object next() {
            String rep = this._stringReps[this._index++];
            return ForBean.this.getValueFromStringRep(this._sourceIterator, this._fullSourceIterator, this._repToValueMap, rep);
        }

        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

