/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.coerce;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.ConstructorUtils;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.coerce.CoerceMessages;
import org.apache.tapestry.coerce.TypeConverter;
import org.apache.tapestry.coerce.TypeConverterContribution;
import org.apache.tapestry.coerce.ValueConverter;

public class ValueConverterImpl
implements ValueConverter {
    public List _contributions;
    private Map _converterMap = new HashMap();
    private Map _primitiveToWrapper = new HashMap();
    private Map _wrapperToPrimitive = new HashMap();

    public ValueConverterImpl() {
        this.store(Boolean.TYPE, Boolean.class);
        this.store(Byte.TYPE, Byte.class);
        this.store(Short.TYPE, Short.class);
        this.store(Character.TYPE, Character.class);
        this.store(Integer.TYPE, Integer.class);
        this.store(Long.TYPE, Long.class);
        this.store(Float.TYPE, Float.class);
        this.store(Double.TYPE, Double.class);
    }

    private void store(Class primitive, Class wrapper) {
        this._primitiveToWrapper.put(primitive, wrapper);
        this._wrapperToPrimitive.put(wrapper, primitive);
    }

    public void initializeService() {
        for (TypeConverterContribution c : this._contributions) {
            this._converterMap.put(c.getSubjectClass(), c.getConverter());
        }
    }

    public Object coerceValue(Object value, Class desiredType) {
        Defense.notNull((Object)desiredType, (String)"desiredType");
        Class effectiveType = this.convertType(desiredType);
        if (value != null && effectiveType.isAssignableFrom(value.getClass())) {
            return value;
        }
        Number result = this.convertNumberToNumber(value, effectiveType);
        if (result != null) {
            return result;
        }
        result = this.convertUsingPropertyEditor(value, effectiveType);
        if (result != null) {
            return result;
        }
        TypeConverter converter = (TypeConverter)this._converterMap.get(effectiveType);
        if (value == null && converter == null) {
            return null;
        }
        if (converter == null) {
            throw new ApplicationRuntimeException(CoerceMessages.noConverter(effectiveType));
        }
        return converter.convertValue(value);
    }

    private Number convertUsingPropertyEditor(Object value, Class targetType) {
        if (value == null || value.getClass() != String.class || !Number.class.isAssignableFrom(targetType)) {
            return null;
        }
        Class primitiveType = (Class)this._wrapperToPrimitive.get(targetType);
        if (primitiveType == null) {
            return null;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(primitiveType);
        if (editor == null) {
            return null;
        }
        String text = (String)value;
        try {
            editor.setAsText(text);
            return (Number)editor.getValue();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(CoerceMessages.stringToNumberConversionError(text, targetType, ex), (Throwable)ex);
        }
    }

    private Number convertNumberToNumber(Object value, Class targetType) {
        if (value == null || !Number.class.isAssignableFrom(value.getClass()) || !Number.class.isAssignableFrom(targetType)) {
            return null;
        }
        String valueAsString = value.toString();
        return (Number)ConstructorUtils.invokeConstructor((Class)targetType, (Object[])new Object[]{valueAsString});
    }

    private Class convertType(Class possiblePrimitiveType) {
        Class wrapperType = (Class)this._primitiveToWrapper.get(possiblePrimitiveType);
        return wrapperType == null ? possiblePrimitiveType : wrapperType;
    }

    public void setContributions(List contributions) {
        this._contributions = contributions;
    }
}

