/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Resource;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.EventListener;
import org.apache.tapestry.annotations.SecondaryAnnotationWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.services.impl.ComponentEventInvoker;
import org.apache.tapestry.spec.IComponentSpecification;

public class EventListenerAnnotationWorker
implements SecondaryAnnotationWorker {
    private ComponentEventInvoker _invoker;

    public boolean canEnhance(Method method) {
        return method.getAnnotation(EventListener.class) != null;
    }

    public void peformEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Resource classResource) {
        int i;
        EventListener listener = method.getAnnotation(EventListener.class);
        String[] targets = listener.targets();
        String[] elements = listener.elements();
        String formId = listener.submitForm();
        boolean validateForm = listener.validateForm();
        boolean async = listener.async();
        if (targets.length < 1 && elements.length < 1) {
            throw new ApplicationRuntimeException(AnnotationMessages.targetsNotFound(method));
        }
        for (i = 0; i < targets.length; ++i) {
            this._invoker.addEventListener(targets[i], listener.events(), method.getName(), formId, validateForm, async);
        }
        for (i = 0; i < elements.length; ++i) {
            this._invoker.addElementEventListener(elements[i], listener.events(), method.getName(), formId, validateForm, async);
        }
    }

    public void setComponentEventInvoker(ComponentEventInvoker invoker) {
        this._invoker = invoker;
    }
}

