/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.services.PropertyAdapterImpl;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.GenericsUtils;
import org.apache.tapestry5.ioc.internal.util.InternalCommonsUtils;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAdapter;

public class ClassPropertyAdapterImpl
implements ClassPropertyAdapter {
    private final Map<String, PropertyAdapter> adapters = CollectionFactory.newCaseInsensitiveMap();
    private final Class beanType;

    public ClassPropertyAdapterImpl(Class beanType, List<PropertyDescriptor> descriptors) {
        PropertyAdapterImpl pa;
        Class propertyType;
        this.beanType = beanType;
        Map<String, List<Method>> nonBridgeMethods = null;
        for (PropertyDescriptor pd : descriptors) {
            Class thisPropertyType = pd.getPropertyType();
            if (thisPropertyType == null) continue;
            Method readMethod = pd.getReadMethod();
            Method writeMethod = pd.getWriteMethod();
            if (readMethod != null && readMethod.isBridge()) {
                if (nonBridgeMethods == null) {
                    nonBridgeMethods = this.groupNonBridgeMethodsByName(beanType);
                }
                readMethod = this.findMethodWithSameNameAndParamCount(readMethod, nonBridgeMethods);
            }
            if (readMethod == null) {
                String prefix = thisPropertyType != Boolean.TYPE ? "get" : "is";
                try {
                    Method method = beanType.getMethod(prefix + ClassPropertyAdapterImpl.capitalize(pd.getName()), new Class[0]);
                    Class<?> returnType = method.getReturnType();
                    if (returnType.equals(thisPropertyType) || returnType.isInstance(thisPropertyType)) {
                        readMethod = method;
                    }
                }
                catch (SecurityException method) {
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            if (writeMethod != null && writeMethod.isBridge()) {
                if (nonBridgeMethods == null) {
                    nonBridgeMethods = this.groupNonBridgeMethodsByName(beanType);
                }
                writeMethod = this.findMethodWithSameNameAndParamCount(writeMethod, nonBridgeMethods);
            }
            if (writeMethod == null) {
                try {
                    Method method = beanType.getMethod("set" + ClassPropertyAdapterImpl.capitalize(pd.getName()), pd.getPropertyType());
                    Class<?> returnType = method.getReturnType();
                    if (returnType.equals(Void.TYPE)) {
                        writeMethod = method;
                    }
                }
                catch (SecurityException method) {
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            propertyType = readMethod == null ? thisPropertyType : GenericsUtils.extractGenericReturnType((Class)beanType, (Method)readMethod);
            pa = new PropertyAdapterImpl(this, pd.getName(), propertyType, readMethod, writeMethod);
            this.adapters.put(pa.getName(), pa);
        }
        for (Field f : beanType.getFields()) {
            String name = f.getName();
            if (this.adapters.containsKey(name)) continue;
            propertyType = GenericsUtils.extractGenericFieldType((Class)beanType, (Field)f);
            pa = new PropertyAdapterImpl(this, name, propertyType, f);
            this.adapters.put(name, pa);
        }
    }

    private static String capitalize(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private Method findMethodWithSameNameAndParamCount(Method method, Map<String, List<Method>> groupedMethods) {
        List<Method> methodGroup = groupedMethods.get(method.getName());
        if (methodGroup != null) {
            for (Method nonBridgeMethod : methodGroup) {
                if (nonBridgeMethod.getParameterTypes().length != method.getParameterTypes().length) continue;
                return nonBridgeMethod;
            }
        }
        return method;
    }

    private Map<String, List<Method>> groupNonBridgeMethodsByName(Class type) {
        Map methodGroupsByName = CollectionFactory.newMap();
        for (Method method : type.getMethods()) {
            if (method.isBridge()) continue;
            List methodGroup = (List)methodGroupsByName.get(method.getName());
            if (methodGroup == null) {
                methodGroup = CollectionFactory.newList();
                methodGroupsByName.put(method.getName(), methodGroup);
            }
            methodGroup.add(method);
        }
        return methodGroupsByName;
    }

    public Class getBeanType() {
        return this.beanType;
    }

    public String toString() {
        String names = InternalCommonsUtils.joinSorted(this.adapters.keySet());
        return String.format("<ClassPropertyAdaptor %s: %s>", this.beanType.getName(), names);
    }

    public List<String> getPropertyNames() {
        return InternalCommonsUtils.sortedKeys(this.adapters);
    }

    public PropertyAdapter getPropertyAdapter(String name) {
        return this.adapters.get(name);
    }

    public Object get(Object instance, String propertyName) {
        return this.adaptorFor(propertyName).get(instance);
    }

    public void set(Object instance, String propertyName, Object value) {
        this.adaptorFor(propertyName).set(instance, value);
    }

    public Annotation getAnnotation(Object instance, String propertyName, Class<? extends Annotation> annotationClass) {
        return this.adaptorFor(propertyName).getAnnotation(annotationClass);
    }

    private PropertyAdapter adaptorFor(String name) {
        PropertyAdapter pa = this.adapters.get(name);
        if (pa == null) {
            throw new IllegalArgumentException(ServiceMessages.noSuchProperty((Class)this.beanType, (String)name));
        }
        return pa;
    }
}

