/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractColumnsView;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.IRenderable;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.NullResponse;

final class MiddleColumnsView
extends AbstractColumnsView {
    private static final long serialVersionUID = 1L;
    private final boolean treeHasLeftColumn;

    public MiddleColumnsView(String id, TreeNode node, boolean treeHasLeftColumn) {
        super(id, node);
        this.treeHasLeftColumn = treeHasLeftColumn;
    }

    protected double[] computeColumnWidths() {
        double[] result = new double[this.columns.size()];
        Arrays.fill(result, 0.0);
        double sum = 0.0;
        double whole = 99.8;
        for (IColumn column : this.columns) {
            if (column.getLocation().getUnit() != ColumnLocation.Unit.PROPORTIONAL) {
                throw new IllegalStateException("Middle columns must have PROPORTIONAL unit set.");
            }
            sum += (double)column.getLocation().getSize();
        }
        int index = 0;
        int spanColumn = 0;
        int spanLeft = 0;
        for (IColumn column : this.columns) {
            int ix = index;
            if (spanLeft > 0) {
                ix = spanColumn;
                --spanLeft;
            }
            int n = ix;
            result[n] = result[n] + (double)Math.round((double)column.getLocation().getSize() / sum * whole);
            if (spanLeft == 0 && column.getSpan(this.node) > 1) {
                int maxSpan = this.columns.size() - this.columns.indexOf(column);
                int span = column.getSpan(this.node) - 1;
                spanColumn = index;
                spanLeft = span < maxSpan ? span : maxSpan;
            }
            ++index;
        }
        double together = 0.0;
        for (double value : result) {
            together += value;
        }
        if (together > 99.8) {
            for (int i = result.length - 1; i >= 0; --i) {
                if (result[i] == 0.0) continue;
                int n = i;
                result[n] = result[n] - (together - 99.8);
                break;
            }
        }
        return result;
    }

    protected void onRender() {
        Response response = RequestCycle.get().getResponse();
        double[] widths = this.computeColumnWidths();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMaximumFractionDigits(0);
        nf.setMaximumIntegerDigits(3);
        for (int i = 0; i < this.columns.size(); ++i) {
            Component component = (Component)this.components.get(i);
            IRenderable renderable = (IRenderable)this.renderables.get(i);
            IColumn column = (IColumn)this.columns.get(i);
            response.write((CharSequence)("<span class=\"b_\" style=\"width:" + nf.format(widths[i]) + "%\">"));
            if (!this.treeHasLeftColumn && i == 0) {
                response.write((CharSequence)"<span class=\"d_\">");
            } else {
                response.write((CharSequence)"<span class=\"c_\">");
            }
            if (component != null) {
                component.render();
            } else if (renderable != null) {
                renderable.render(this.node, response);
            } else {
                throw new IllegalStateException("Either renderable or cell component must be created for this noode");
            }
            response.write((CharSequence)"</span></span>\n");
            int span = column.getSpan(this.node);
            if (span <= 1) continue;
            for (int j = 1; j < span && i < this.components.size(); ++j) {
                if (this.components.get(++i) == null) continue;
                Response old = RequestCycle.get().setResponse((Response)NullResponse.getInstance());
                ((Component)this.components.get(i)).render();
                RequestCycle.get().setResponse(old);
            }
        }
    }
}

