/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.mock.MockWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.ResourceStreamWrapper;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageResource
extends AbstractResource
implements IStaticCacheableResource {
    private static final Logger log = LoggerFactory.getLogger(PackageResource.class);
    private static final long serialVersionUID = 1L;
    private final String absolutePath;
    private final Locale locale;
    private final String path;
    private final String scopeName;
    private final String style;
    private final String variation;
    private boolean compress = false;
    private boolean cachingEnabled = true;
    private String textEncoding = null;

    protected PackageResource(Class<?> scope, String name, Locale locale, String style, String variation) {
        this.absolutePath = Packages.absolutePath(scope, (String)name);
        String parentEscape = this.getParentFolderPlaceholder();
        this.path = !Strings.isEmpty((CharSequence)parentEscape) ? ((Object)Strings.replaceAll((CharSequence)name, (CharSequence)"../", (CharSequence)(parentEscape + "/"))).toString() : name;
        this.scopeName = scope.getName();
        this.locale = locale;
        this.style = style;
        this.variation = variation;
    }

    private Locale getCurrentLocale() {
        return this.locale != null ? this.locale : Session.get().getLocale();
    }

    private String getCurrentStyle() {
        return this.style != null ? this.style : Session.get().getStyle();
    }

    @Override
    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }

    @Override
    public Serializable getCacheKey() {
        IResourceStream stream = this.getCacheableResourceStream();
        if (stream == null) {
            return null;
        }
        return new CacheKey(this.scopeName, this.absolutePath, stream.getLocale(), stream.getStyle(), stream.getVariation());
    }

    public final Class<?> getScope() {
        return WicketObjects.resolveClass(this.scopeName);
    }

    public final String getStyle() {
        return this.style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        IResourceStream resourceStream = this.getResourceStream();
        if (resourceStream == null) {
            return this.sendResourceError(resourceResponse, 404, "Unable to find resource");
        }
        Time lastModified = resourceStream.lastModifiedTime();
        resourceResponse.setLastModified(lastModified);
        if (resourceResponse.dataNeedsToBeWritten(attributes)) {
            String contentType = resourceStream.getContentType();
            if (contentType == null && Application.exists()) {
                contentType = Application.get().getMimeType(this.path);
            }
            resourceResponse.setContentType(contentType);
            resourceResponse.setTextEncoding(this.getTextEncoding());
            try {
                final byte[] bytes = IOUtils.toByteArray((InputStream)resourceStream.getInputStream());
                resourceResponse.setContentLength(bytes.length);
                resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                    @Override
                    public void writeData(IResource.Attributes attributes) {
                        attributes.getResponse().write(bytes);
                    }
                });
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
                AbstractResource.ResourceResponse resourceResponse2 = this.sendResourceError(resourceResponse, 500, "Unable to read resource stream");
                return resourceResponse2;
            }
            catch (ResourceStreamNotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
                AbstractResource.ResourceResponse resourceResponse3 = this.sendResourceError(resourceResponse, 500, "Unable to open resource stream");
                return resourceResponse3;
            }
            finally {
                try {
                    resourceStream.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close the resource stream", (Throwable)e);
                }
            }
        }
        return resourceResponse;
    }

    protected byte[] processResponse(IResource.Attributes attributes, byte[] original) {
        return original;
    }

    private AbstractResource.ResourceResponse sendResourceError(AbstractResource.ResourceResponse resourceResponse, int errorCode, String errorMessage) {
        String msg = String.format("resource [path = %s, style = %s, variation = %s, locale = %s]: %s (status=%d)", this.absolutePath, this.style, this.variation, this.locale, errorMessage, errorCode);
        log.warn(msg);
        resourceResponse.setError(errorCode, errorMessage);
        return resourceResponse;
    }

    @Override
    public IResourceStream getCacheableResourceStream() {
        return this.internalGetResourceStream(this.getCurrentStyle(), this.getCurrentLocale());
    }

    public IResourceStream getResourceStream() {
        return this.internalGetResourceStream(this.style, this.locale);
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    private IResourceStream internalGetResourceStream(String style, Locale locale) {
        IResourceStreamLocator resourceStreamLocator = Application.get().getResourceSettings().getResourceStreamLocator();
        Object resourceStream = resourceStreamLocator.locate(this.getScope(), this.absolutePath, style, this.variation, locale, null, false);
        Class<?> realScope = this.getScope();
        String realPath = this.absolutePath;
        if (resourceStream instanceof IFixedLocationResourceStream) {
            realPath = ((IFixedLocationResourceStream)resourceStream).locationAsString();
            if (realPath != null) {
                int index = realPath.indexOf(this.absolutePath);
                if (index != -1) {
                    realPath = realPath.substring(index);
                } else {
                    realScope = null;
                }
            } else {
                realPath = this.absolutePath;
            }
        }
        if (!this.accept(realScope, realPath)) {
            throw new PackageResourceBlockedException("Access denied to (static) package resource " + this.absolutePath + ". See IPackageResourceGuard");
        }
        if (resourceStream != null) {
            resourceStream = new ProcessingResourceStream((IResourceStream)resourceStream);
        }
        return resourceStream;
    }

    protected boolean accept(Class<?> scope, String path) {
        IPackageResourceGuard guard = Application.get().getResourceSettings().getPackageResourceGuard();
        return guard.accept(scope, path);
    }

    public static boolean exists(ResourceReference.Key key) {
        return PackageResource.exists(key.getScopeClass(), key.getName(), key.getLocale(), key.getStyle(), key.getVariation());
    }

    public static boolean exists(Class<?> scope, String path, Locale locale, String style, String variation) {
        String absolutePath = Packages.absolutePath(scope, (String)path);
        return Application.get().getResourceSettings().getResourceStreamLocator().locate(scope, absolutePath, style, variation, locale, null, false) != null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[').append(Classes.simpleName(this.getClass())).append(' ').append("name = ").append(this.path).append(", scope = ").append(this.scopeName).append(", locale = ").append(this.locale).append(", style = ").append(this.style).append(", variation = ").append(this.variation).append(']');
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.absolutePath == null ? 0 : this.absolutePath.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.scopeName == null ? 0 : this.scopeName.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        result = 31 * result + (this.variation == null ? 0 : this.variation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageResource other = (PackageResource)obj;
        if (this.absolutePath == null ? other.absolutePath != null : !this.absolutePath.equals(other.absolutePath)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.scopeName == null ? other.scopeName != null : !this.scopeName.equals(other.scopeName)) {
            return false;
        }
        if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
            return false;
        }
        return !(this.variation == null ? other.variation != null : !this.variation.equals(other.variation));
    }

    String getParentFolderPlaceholder() {
        String parentFolderPlaceholder = Application.exists() ? Application.get().getResourceSettings().getParentFolderPlaceholder() : "..";
        return parentFolderPlaceholder;
    }

    private static class CacheKey
    implements Serializable {
        private final String scopeName;
        private final String path;
        private final Locale locale;
        private final String style;
        private final String variation;

        public CacheKey(String scopeName, String path, Locale locale, String style, String variation) {
            this.scopeName = scopeName;
            this.path = path;
            this.locale = locale;
            this.style = style;
            this.variation = variation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.locale != null ? !this.locale.equals(cacheKey.locale) : cacheKey.locale != null) {
                return false;
            }
            if (!this.path.equals(cacheKey.path)) {
                return false;
            }
            if (!this.scopeName.equals(cacheKey.scopeName)) {
                return false;
            }
            if (this.style != null ? !this.style.equals(cacheKey.style) : cacheKey.style != null) {
                return false;
            }
            return !(this.variation != null ? !this.variation.equals(cacheKey.variation) : cacheKey.variation != null);
        }

        public int hashCode() {
            int result = this.scopeName.hashCode();
            result = 31 * result + this.path.hashCode();
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.style != null ? this.style.hashCode() : 0);
            result = 31 * result + (this.variation != null ? this.variation.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CacheKey");
            sb.append("{scopeName='").append(this.scopeName).append('\'');
            sb.append(", path='").append(this.path).append('\'');
            sb.append(", locale=").append(this.locale);
            sb.append(", style='").append(this.style).append('\'');
            sb.append(", variation='").append(this.variation).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    private class ProcessingResourceStream
    extends ResourceStreamWrapper {
        private ProcessingResourceStream(IResourceStream delegate) {
            super(delegate);
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            byte[] bytes;
            InputStream inputStream = super.getInputStream();
            try {
                bytes = IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (IOException iox) {
                throw new WicketRuntimeException(iox);
            }
            RequestCycle cycle = RequestCycle.get();
            IResource.Attributes attributes = cycle != null ? new IResource.Attributes(cycle.getRequest(), cycle.getResponse()) : new IResource.Attributes((Request)new MockWebRequest(Url.parse((CharSequence)"")), new StringResponse());
            byte[] processedBytes = PackageResource.this.processResponse(attributes, bytes);
            return new ByteArrayInputStream(processedBytes);
        }
    }

    public static final class PackageResourceBlockedException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        public PackageResourceBlockedException(String message) {
            super(message);
        }
    }
}

