/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public abstract class AbstractMarkupSourcingStrategy
implements IMarkupSourcingStrategy {
    @Override
    public abstract IMarkupFragment getMarkup(MarkupContainer var1, Component var2);

    protected IMarkupFragment searchMarkupInTransparentResolvers(MarkupContainer container, final Component child) {
        return container.visitChildren(MarkupContainer.class, new IVisitor<MarkupContainer, IMarkupFragment>(){

            public void component(MarkupContainer resolvingContainer, IVisit<IMarkupFragment> visit) {
                IMarkupFragment childMarkup;
                if (resolvingContainer instanceof IComponentResolver && (childMarkup = resolvingContainer.getMarkup(child)) != null && childMarkup.size() > 0) {
                    IComponentResolver componentResolver = (IComponentResolver)((Object)resolvingContainer);
                    MarkupStream stream = new MarkupStream(childMarkup);
                    ComponentTag tag = stream.getTag();
                    Component resolvedComponent = resolvingContainer.get(tag.getId());
                    if (resolvedComponent == null) {
                        resolvedComponent = componentResolver.resolve(resolvingContainer, stream, tag);
                    }
                    if (child == resolvedComponent) {
                        visit.stop((Object)childMarkup);
                    }
                }
            }
        });
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        if (tag.isOpenClose()) {
            tag.setType(XmlTag.TagType.OPEN);
        }
    }

    @Override
    public void onComponentTagBody(Component component, MarkupStream markupStream, ComponentTag openTag) {
        if (markupStream.getPreviousTag().isOpen()) {
            markupStream.skipRawMarkup();
            if (!markupStream.get().closes(openTag)) {
                throw new MarkupException(markupStream, "Close tag not found for tag: " + openTag.toString() + ". For " + Classes.simpleName(component.getClass()) + " Components only raw markup is allow in between the tags but not other Wicket Component." + ". Component: " + component.toString());
            }
        }
    }

    @Override
    public void renderHead(Component component, HtmlHeaderContainer container) {
    }
}

