/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.LinkedList;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractMarkupFragment
implements IMarkupFragment {
    protected final IMarkupFragment find(String id, int streamOffset) {
        Args.notEmpty((CharSequence)id, (String)"id");
        Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.size() - 1), (Comparable)Integer.valueOf(streamOffset), (String)"streamOffset");
        LinkedList<Boolean> openTagUsability = new LinkedList<Boolean>();
        boolean canFind = true;
        MarkupStream stream = new MarkupStream(this);
        stream.setCurrentIndex(streamOffset);
        while (stream.hasMore()) {
            MarkupElement elem = stream.get();
            if (elem instanceof ComponentTag) {
                ComponentTag tag = stream.getTag();
                if (tag.isOpen() || tag.isOpenClose()) {
                    if (canFind && tag.getId().equals(id)) {
                        return stream.getMarkupFragment();
                    }
                    if (tag.isOpen() && !tag.hasNoCloseTag()) {
                        openTagUsability.push(canFind);
                        if (tag instanceof WicketTag) {
                            WicketTag wtag = (WicketTag)tag;
                            if (wtag.isExtendTag()) {
                                canFind = true;
                            } else if (wtag.isFragementTag()) {
                                canFind = false;
                            }
                        } else if (!"head".equals(tag.getName()) && !tag.isAutoComponentTag()) {
                            canFind = false;
                        }
                    }
                } else if (tag.isClose()) {
                    canFind = openTagUsability.isEmpty() ? false : (Boolean)openTagUsability.pop();
                }
            }
            stream.next();
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }
}

