/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.wicket.ApplicationListenerCollection;
import org.apache.wicket.BehaviorInstantiationListenerCollection;
import org.apache.wicket.Component;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.DefaultExceptionMapper;
import org.apache.wicket.DefaultMapperContext;
import org.apache.wicket.DefaultMarkupIdGenerator;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.IDetachListener;
import org.apache.wicket.IInitializer;
import org.apache.wicket.IMarkupIdGenerator;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.IPageRendererProvider;
import org.apache.wicket.IRequestCycleProvider;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceBundles;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.SessionListenerCollection;
import org.apache.wicket.SharedResources;
import org.apache.wicket.SystemMapper;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.ComponentInitializationListenerCollection;
import org.apache.wicket.application.ComponentInstantiationListenerCollection;
import org.apache.wicket.application.ComponentOnAfterRenderListenerCollection;
import org.apache.wicket.application.ComponentOnBeforeRenderListenerCollection;
import org.apache.wicket.application.ComponentOnConfigureListenerCollection;
import org.apache.wicket.application.HeaderContributorListenerCollection;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.core.util.resource.ClassPathResourceFinder;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.javascript.DefaultJavaScriptCompressor;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.ResourceAggregator;
import org.apache.wicket.markup.html.IHeaderResponseDecorator;
import org.apache.wicket.markup.html.image.resource.DefaultButtonImageResourceFactory;
import org.apache.wicket.markup.parser.filter.EnclosureHandler;
import org.apache.wicket.markup.parser.filter.InlineEnclosureHandler;
import org.apache.wicket.markup.parser.filter.RelativePathPrefixHandler;
import org.apache.wicket.markup.parser.filter.WicketLinkTagHandler;
import org.apache.wicket.markup.parser.filter.WicketMessageTagHandler;
import org.apache.wicket.markup.resolver.FragmentResolver;
import org.apache.wicket.markup.resolver.HtmlHeaderResolver;
import org.apache.wicket.markup.resolver.MarkupInheritanceResolver;
import org.apache.wicket.markup.resolver.WicketContainerResolver;
import org.apache.wicket.markup.resolver.WicketMessageResolver;
import org.apache.wicket.page.DefaultPageManagerContext;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.RequestLoggerRequestCycleListener;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.cycle.RequestCycleListenerCollection;
import org.apache.wicket.request.mapper.CompoundRequestMapper;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;
import org.apache.wicket.response.filter.EmptySrcAttributeCheckFilter;
import org.apache.wicket.session.DefaultPageFactory;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.settings.IFrameworkSettings;
import org.apache.wicket.settings.IJavaScriptLibrarySettings;
import org.apache.wicket.settings.IMarkupSettings;
import org.apache.wicket.settings.IPageSettings;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.settings.IRequestLoggerSettings;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.settings.ISecuritySettings;
import org.apache.wicket.settings.IStoreSettings;
import org.apache.wicket.settings.def.ApplicationSettings;
import org.apache.wicket.settings.def.DebugSettings;
import org.apache.wicket.settings.def.ExceptionSettings;
import org.apache.wicket.settings.def.FrameworkSettings;
import org.apache.wicket.settings.def.JavaScriptLibrarySettings;
import org.apache.wicket.settings.def.MarkupSettings;
import org.apache.wicket.settings.def.PageSettings;
import org.apache.wicket.settings.def.RequestCycleSettings;
import org.apache.wicket.settings.def.RequestLoggerSettings;
import org.apache.wicket.settings.def.ResourceSettings;
import org.apache.wicket.settings.def.SecuritySettings;
import org.apache.wicket.settings.def.StoreSettings;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Application
implements ISessionStore.UnboundListener,
IEventSink {
    public static final String CONFIGURATION = "configuration";
    private static final Map<String, Application> applicationKeyToApplication = Generics.newHashMap((int)1);
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private IRequestMapper rootRequestMapper;
    private IConverterLocator converterLocator;
    private final List<IInitializer> initializers = Generics.newArrayList();
    private MetaDataEntry<?>[] metaData;
    private String name;
    private IRequestLogger requestLogger;
    private volatile ISessionStore sessionStore;
    private IPageRendererProvider pageRendererProvider;
    private IRequestCycleProvider requestCycleProvider;
    private IProvider<IExceptionMapper> exceptionMapperProvider;
    private IProvider<ISessionStore> sessionStoreProvider;
    private IHeaderResponseDecorator headerResponseDecorator;
    private IMarkupIdGenerator markupIdGenerator = new DefaultMarkupIdGenerator();
    private final ComponentOnBeforeRenderListenerCollection componentPreOnBeforeRenderListeners = new ComponentOnBeforeRenderListenerCollection();
    private final ComponentOnBeforeRenderListenerCollection componentPostOnBeforeRenderListeners = new ComponentOnBeforeRenderListenerCollection();
    private final ComponentOnAfterRenderListenerCollection componentOnAfterRenderListeners = new ComponentOnAfterRenderListenerCollection();
    private final RequestCycleListenerCollection requestCycleListeners = new RequestCycleListenerCollection();
    private final ApplicationListenerCollection applicationListeners = new ApplicationListenerCollection();
    private final SessionListenerCollection sessionListeners = new SessionListenerCollection();
    private final ComponentInstantiationListenerCollection componentInstantiationListeners = new ComponentInstantiationListenerCollection();
    private final ComponentInitializationListenerCollection componentInitializationListeners = new ComponentInitializationListenerCollection();
    private final ComponentOnConfigureListenerCollection componentOnConfigureListeners = new ComponentOnConfigureListenerCollection();
    private final HeaderContributorListenerCollection headerContributorListenerCollection = new HeaderContributorListenerCollection();
    private final BehaviorInstantiationListenerCollection behaviorInstantiationListeners = new BehaviorInstantiationListenerCollection();
    private IApplicationSettings applicationSettings;
    private IJavaScriptLibrarySettings javaScriptLibrarySettings;
    private IDebugSettings debugSettings;
    private IExceptionSettings exceptionSettings;
    private IFrameworkSettings frameworkSettings;
    private IMarkupSettings markupSettings;
    private IPageSettings pageSettings;
    private IRequestCycleSettings requestCycleSettings;
    private IRequestLoggerSettings requestLoggerSettings;
    private IResourceSettings resourceSettings;
    private ISecuritySettings securitySettings;
    private IStoreSettings storeSettings;
    private boolean settingsAccessible;
    private volatile IPageManager pageManager;
    private IPageManagerProvider pageManagerProvider;
    private final IPageManagerContext pageManagerContext = new DefaultPageManagerContext();
    private ResourceReferenceRegistry resourceReferenceRegistry;
    private SharedResources sharedResources;
    private ResourceBundles resourceBundles;
    private IPageFactory pageFactory;
    private IMapperContext encoderContext;

    public static boolean exists() {
        return ThreadContext.getApplication() != null;
    }

    public static Application get() {
        Application application = ThreadContext.getApplication();
        if (application == null) {
            throw new WicketRuntimeException("There is no application attached to current thread " + Thread.currentThread().getName());
        }
        return application;
    }

    public static Application get(String applicationKey) {
        return applicationKeyToApplication.get(applicationKey);
    }

    public static Set<String> getApplicationKeys() {
        return Collections.unmodifiableSet(applicationKeyToApplication.keySet());
    }

    public Application() {
        this.getComponentInstantiationListeners().add(new IComponentInstantiationListener(){

            @Override
            public void onInstantiation(Component component) {
                Class<?> cl = component.getClass();
                if (!Session.get().getAuthorizationStrategy().isInstantiationAuthorized(cl)) {
                    Application.this.getSecuritySettings().getUnauthorizedComponentInstantiationListener().onUnauthorizedInstantiation(component);
                }
            }
        });
    }

    public final void configure() {
        switch (this.getConfigurationType()) {
            case DEVELOPMENT: {
                this.getResourceSettings().setResourcePollFrequency(Duration.ONE_SECOND);
                this.getResourceSettings().setJavaScriptCompressor(null);
                this.getResourceSettings().setUseMinifiedResources(false);
                this.getMarkupSettings().setStripWicketTags(false);
                this.getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_EXCEPTION_PAGE);
                this.getDebugSettings().setComponentUseCheck(true);
                this.getDebugSettings().setAjaxDebugModeEnabled(true);
                this.getDebugSettings().setDevelopmentUtilitiesEnabled(true);
                this.getRequestCycleSettings().addResponseFilter(EmptySrcAttributeCheckFilter.INSTANCE);
                break;
            }
            case DEPLOYMENT: {
                this.getResourceSettings().setResourcePollFrequency(null);
                this.getResourceSettings().setJavaScriptCompressor(new DefaultJavaScriptCompressor());
                this.getMarkupSettings().setStripWicketTags(true);
                this.getExceptionSettings().setUnexpectedExceptionDisplay(IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
                this.getDebugSettings().setComponentUseCheck(false);
                this.getDebugSettings().setAjaxDebugModeEnabled(false);
                this.getDebugSettings().setDevelopmentUtilitiesEnabled(false);
            }
        }
    }

    public abstract String getApplicationKey();

    public abstract RuntimeConfigurationType getConfigurationType();

    public abstract Class<? extends Page> getHomePage();

    public final IConverterLocator getConverterLocator() {
        return this.converterLocator;
    }

    public final <T> T getMetaData(MetaDataKey<T> key) {
        return key.get(this.metaData);
    }

    public final String getName() {
        return this.name;
    }

    public final IRequestLogger getRequestLogger() {
        if (this.getRequestLoggerSettings().isRequestLoggerEnabled()) {
            if (this.requestLogger == null) {
                this.requestLogger = this.newRequestLogger();
            }
        } else {
            this.requestLogger = null;
        }
        return this.requestLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISessionStore getSessionStore() {
        if (this.sessionStore == null) {
            Application application = this;
            synchronized (application) {
                if (this.sessionStore == null) {
                    this.sessionStore = (ISessionStore)this.sessionStoreProvider.get();
                    this.sessionStore.registerUnboundListener(this);
                }
            }
        }
        return this.sessionStore;
    }

    @Override
    public void sessionUnbound(String sessionId) {
        this.internalGetPageManager().sessionExpired(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void initializeComponents() {
        try {
            Iterator<URL> resources = this.getApplicationSettings().getClassResolver().getResources("wicket.properties");
            while (resources.hasNext()) {
                InputStream in = null;
                try {
                    URL url = resources.next();
                    Properties properties = new Properties();
                    in = Streams.readNonCaching((URL)url);
                    properties.load(in);
                    this.load(properties);
                }
                catch (Throwable throwable) {
                    IOUtils.close(in);
                    throw throwable;
                }
                IOUtils.close((Closeable)in);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to load initializers file", e);
        }
        this.initInitializers();
    }

    public void logEventTarget(IRequestHandler target) {
    }

    public void logResponseTarget(IRequestHandler requestTarget) {
    }

    public abstract Session newSession(Request var1, Response var2);

    public final synchronized <T> void setMetaData(MetaDataKey<T> key, Object object) {
        this.metaData = key.set(this.metaData, object);
    }

    private void addInitializer(String className) {
        IInitializer initializer = (IInitializer)WicketObjects.newInstance(className);
        if (initializer != null) {
            this.initializers.add(initializer);
        }
    }

    private void destroyInitializers() {
        for (IInitializer initializer : this.initializers) {
            log.info("[" + this.getName() + "] destroy: " + initializer);
            initializer.destroy(this);
        }
    }

    private void initInitializers() {
        for (IInitializer initializer : this.initializers) {
            log.info("[" + this.getName() + "] init: " + initializer);
            initializer.init(this);
        }
    }

    private void load(Properties properties) {
        this.addInitializer(properties.getProperty("initializer"));
        this.addInitializer(properties.getProperty(this.getName() + "-initializer"));
    }

    protected void onDestroy() {
    }

    protected void init() {
    }

    public void internalDestroy() {
        this.applicationListeners.onBeforeDestroyed(this);
        IDetachListener detachListener = this.getFrameworkSettings().getDetachListener();
        if (detachListener != null) {
            detachListener.onDestroyListener();
        }
        PropertyResolver.destroy(this);
        MarkupFactory markupFactory = this.getMarkupSettings().getMarkupFactory();
        if (markupFactory.hasMarkupCache()) {
            markupFactory.getMarkupCache().shutdown();
        }
        this.onDestroy();
        this.destroyInitializers();
        this.internalGetPageManager().destroy();
        this.getSessionStore().destroy();
        applicationKeyToApplication.remove(this.getApplicationKey());
    }

    protected void internalInit() {
        this.settingsAccessible = true;
        IPageSettings pageSettings = this.getPageSettings();
        pageSettings.addComponentResolver(new MarkupInheritanceResolver());
        pageSettings.addComponentResolver(new HtmlHeaderResolver());
        pageSettings.addComponentResolver(new WicketLinkTagHandler());
        pageSettings.addComponentResolver(new WicketMessageResolver());
        pageSettings.addComponentResolver(new FragmentResolver());
        pageSettings.addComponentResolver(new RelativePathPrefixHandler());
        pageSettings.addComponentResolver(new EnclosureHandler());
        pageSettings.addComponentResolver(new InlineEnclosureHandler());
        pageSettings.addComponentResolver(new WicketMessageTagHandler());
        pageSettings.addComponentResolver(new WicketContainerResolver());
        this.getResourceSettings().getResourceFinders().add(new ClassPathResourceFinder(""));
        this.getResourceSettings().addResourceFactory("buttonFactory", new DefaultButtonImageResourceFactory());
        String applicationKey = this.getApplicationKey();
        applicationKeyToApplication.put(applicationKey, this);
        this.converterLocator = this.newConverterLocator();
        this.setPageManagerProvider(new DefaultPageManagerProvider(this));
        this.resourceReferenceRegistry = this.newResourceReferenceRegistry();
        this.sharedResources = this.newSharedResources(this.resourceReferenceRegistry);
        this.resourceBundles = this.newResourceBundles(this.resourceReferenceRegistry);
        this.setRootRequestMapper((IRequestMapper)new SystemMapper(this));
        this.pageFactory = this.newPageFactory();
        this.requestCycleProvider = new DefaultRequestCycleProvider();
        this.exceptionMapperProvider = new DefaultExceptionMapperProvider();
        this.getRequestCycleListeners().add(new RequestLoggerRequestCycleListener());
    }

    public IProvider<IExceptionMapper> getExceptionMapperProvider() {
        return this.exceptionMapperProvider;
    }

    public final IProvider<ISessionStore> getSessionStoreProvider() {
        return this.sessionStoreProvider;
    }

    public final void setSessionStoreProvider(IProvider<ISessionStore> sessionStoreProvider) {
        this.sessionStoreProvider = sessionStoreProvider;
    }

    protected IConverterLocator newConverterLocator() {
        return new ConverterLocator();
    }

    protected IRequestLogger newRequestLogger() {
        return new RequestLogger();
    }

    public final ICompoundRequestMapper getRootRequestMapperAsCompound() {
        IRequestMapper root = this.getRootRequestMapper();
        if (!(root instanceof ICompoundRequestMapper)) {
            root = new CompoundRequestMapper().add(root);
            this.setRootRequestMapper(root);
        }
        return (ICompoundRequestMapper)root;
    }

    public final IRequestMapper getRootRequestMapper() {
        return this.rootRequestMapper;
    }

    public final void setRootRequestMapper(IRequestMapper rootRequestMapper) {
        this.rootRequestMapper = rootRequestMapper;
    }

    public final void initApplication() {
        if (this.name == null) {
            throw new IllegalStateException("setName must be called before initApplication");
        }
        this.internalInit();
        this.initializeComponents();
        this.init();
        this.applicationListeners.onAfterInitialized(this);
        this.validateInit();
    }

    protected void validateInit() {
        if (this.getPageRendererProvider() == null) {
            throw new IllegalStateException("An instance of IPageRendererProvider has not yet been set on this Application. @see Application#setPageRendererProvider");
        }
        if (this.getSessionStoreProvider() == null) {
            throw new IllegalStateException("An instance of ISessionStoreProvider has not yet been set on this Application. @see Application#setSessionStoreProvider");
        }
        if (this.getPageManagerProvider() == null) {
            throw new IllegalStateException("An instance of IPageManagerProvider has not yet been set on this Application. @see Application#setPageManagerProvider");
        }
    }

    public final void setName(String name) {
        Args.notEmpty((CharSequence)name, (String)"name");
        if (this.name != null) {
            throw new IllegalStateException("Application name can only be set once.");
        }
        if (applicationKeyToApplication.get(name) != null) {
            throw new IllegalStateException("Application with name '" + name + "' already exists.'");
        }
        this.name = name;
        applicationKeyToApplication.put(name, this);
    }

    public String getMimeType(String fileName) {
        return URLConnection.getFileNameMap().getContentTypeFor(fileName);
    }

    @Override
    public void onEvent(IEvent<?> event) {
    }

    public final HeaderContributorListenerCollection getHeaderContributorListenerCollection() {
        return this.headerContributorListenerCollection;
    }

    public final List<IInitializer> getInitializers() {
        return Collections.unmodifiableList(this.initializers);
    }

    public final ApplicationListenerCollection getApplicationListeners() {
        return this.applicationListeners;
    }

    public final SessionListenerCollection getSessionListeners() {
        return this.sessionListeners;
    }

    public final BehaviorInstantiationListenerCollection getBehaviorInstantiationListeners() {
        return this.behaviorInstantiationListeners;
    }

    public final ComponentInstantiationListenerCollection getComponentInstantiationListeners() {
        return this.componentInstantiationListeners;
    }

    public final ComponentInitializationListenerCollection getComponentInitializationListeners() {
        return this.componentInitializationListeners;
    }

    public final ComponentOnConfigureListenerCollection getComponentOnConfigureListeners() {
        return this.componentOnConfigureListeners;
    }

    public final ComponentOnBeforeRenderListenerCollection getComponentPreOnBeforeRenderListeners() {
        return this.componentPreOnBeforeRenderListeners;
    }

    public final ComponentOnBeforeRenderListenerCollection getComponentPostOnBeforeRenderListeners() {
        return this.componentPostOnBeforeRenderListeners;
    }

    public final ComponentOnAfterRenderListenerCollection getComponentOnAfterRenderListeners() {
        return this.componentOnAfterRenderListeners;
    }

    public RequestCycleListenerCollection getRequestCycleListeners() {
        return this.requestCycleListeners;
    }

    public final IApplicationSettings getApplicationSettings() {
        this.checkSettingsAvailable();
        if (this.applicationSettings == null) {
            this.applicationSettings = new ApplicationSettings();
        }
        return this.applicationSettings;
    }

    public final void setApplicationSettings(IApplicationSettings applicationSettings) {
        this.applicationSettings = applicationSettings;
    }

    public final IJavaScriptLibrarySettings getJavaScriptLibrarySettings() {
        this.checkSettingsAvailable();
        if (this.javaScriptLibrarySettings == null) {
            this.javaScriptLibrarySettings = new JavaScriptLibrarySettings();
        }
        return this.javaScriptLibrarySettings;
    }

    public final void setJavaScriptLibrarySettings(IJavaScriptLibrarySettings javaScriptLibrarySettings) {
        this.javaScriptLibrarySettings = javaScriptLibrarySettings;
    }

    public final IDebugSettings getDebugSettings() {
        this.checkSettingsAvailable();
        if (this.debugSettings == null) {
            this.debugSettings = new DebugSettings();
        }
        return this.debugSettings;
    }

    public final void setDebugSettings(IDebugSettings debugSettings) {
        this.debugSettings = debugSettings;
    }

    public final IExceptionSettings getExceptionSettings() {
        this.checkSettingsAvailable();
        if (this.exceptionSettings == null) {
            this.exceptionSettings = new ExceptionSettings();
        }
        return this.exceptionSettings;
    }

    public final void setExceptionSettings(IExceptionSettings exceptionSettings) {
        this.exceptionSettings = exceptionSettings;
    }

    public final IFrameworkSettings getFrameworkSettings() {
        this.checkSettingsAvailable();
        if (this.frameworkSettings == null) {
            this.frameworkSettings = new FrameworkSettings(this);
        }
        return this.frameworkSettings;
    }

    public final void setFrameworkSettings(IFrameworkSettings frameworkSettings) {
        this.frameworkSettings = frameworkSettings;
    }

    public final IPageSettings getPageSettings() {
        this.checkSettingsAvailable();
        if (this.pageSettings == null) {
            this.pageSettings = new PageSettings();
        }
        return this.pageSettings;
    }

    public final void setPageSettings(IPageSettings pageSettings) {
        this.pageSettings = pageSettings;
    }

    public final IRequestCycleSettings getRequestCycleSettings() {
        this.checkSettingsAvailable();
        if (this.requestCycleSettings == null) {
            this.requestCycleSettings = new RequestCycleSettings();
        }
        return this.requestCycleSettings;
    }

    public final void setRequestCycleSettings(IRequestCycleSettings requestCycleSettings) {
        this.requestCycleSettings = requestCycleSettings;
    }

    public IMarkupSettings getMarkupSettings() {
        this.checkSettingsAvailable();
        if (this.markupSettings == null) {
            this.markupSettings = new MarkupSettings();
        }
        return this.markupSettings;
    }

    public final void setMarkupSettings(IMarkupSettings markupSettings) {
        this.markupSettings = markupSettings;
    }

    public final IRequestLoggerSettings getRequestLoggerSettings() {
        this.checkSettingsAvailable();
        if (this.requestLoggerSettings == null) {
            this.requestLoggerSettings = new RequestLoggerSettings();
        }
        return this.requestLoggerSettings;
    }

    public final void setRequestLoggerSettings(IRequestLoggerSettings requestLoggerSettings) {
        this.requestLoggerSettings = requestLoggerSettings;
    }

    public final IResourceSettings getResourceSettings() {
        this.checkSettingsAvailable();
        if (this.resourceSettings == null) {
            this.resourceSettings = new ResourceSettings(this);
        }
        return this.resourceSettings;
    }

    public final void setResourceSettings(IResourceSettings resourceSettings) {
        this.resourceSettings = resourceSettings;
    }

    public final ISecuritySettings getSecuritySettings() {
        this.checkSettingsAvailable();
        if (this.securitySettings == null) {
            this.securitySettings = new SecuritySettings();
        }
        return this.securitySettings;
    }

    public final void setSecuritySettings(ISecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
    }

    public final IStoreSettings getStoreSettings() {
        this.checkSettingsAvailable();
        if (this.storeSettings == null) {
            this.storeSettings = new StoreSettings(this);
        }
        return this.storeSettings;
    }

    public final void setStoreSettings(IStoreSettings storeSettings) {
        this.storeSettings = storeSettings;
    }

    private void checkSettingsAvailable() {
        if (!this.settingsAccessible) {
            throw new WicketRuntimeException("Use Application.init() method for configuring your application object");
        }
    }

    public final IPageManagerProvider getPageManagerProvider() {
        return this.pageManagerProvider;
    }

    public final synchronized void setPageManagerProvider(IPageManagerProvider provider) {
        this.pageManagerProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IPageManager internalGetPageManager() {
        if (this.pageManager == null) {
            Application application = this;
            synchronized (application) {
                if (this.pageManager == null) {
                    this.pageManager = (IPageManager)this.pageManagerProvider.get(this.getPageManagerContext());
                }
            }
        }
        return this.pageManager;
    }

    protected IPageManagerContext getPageManagerContext() {
        return this.pageManagerContext;
    }

    public final IPageRendererProvider getPageRendererProvider() {
        return this.pageRendererProvider;
    }

    public final void setPageRendererProvider(IPageRendererProvider pageRendererProvider) {
        Args.notNull((Object)pageRendererProvider, (String)"pageRendererProvider");
        this.pageRendererProvider = pageRendererProvider;
    }

    protected ResourceReferenceRegistry newResourceReferenceRegistry() {
        return new ResourceReferenceRegistry();
    }

    public final ResourceReferenceRegistry getResourceReferenceRegistry() {
        return this.resourceReferenceRegistry;
    }

    protected SharedResources newSharedResources(ResourceReferenceRegistry registry) {
        return new SharedResources(registry);
    }

    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    protected ResourceBundles newResourceBundles(ResourceReferenceRegistry registry) {
        return new ResourceBundles(registry);
    }

    public ResourceBundles getResourceBundles() {
        return this.resourceBundles;
    }

    protected IPageFactory newPageFactory() {
        return new DefaultPageFactory();
    }

    public final IPageFactory getPageFactory() {
        return this.pageFactory;
    }

    public final IMapperContext getMapperContext() {
        if (this.encoderContext == null) {
            this.encoderContext = this.newMapperContext();
        }
        return this.encoderContext;
    }

    protected IMapperContext newMapperContext() {
        return new DefaultMapperContext(this);
    }

    public Session fetchCreateAndSetSession(RequestCycle requestCycle) {
        Args.notNull((Object)requestCycle, (String)"requestCycle");
        Session session = this.getSessionStore().lookup(requestCycle.getRequest());
        if (session == null) {
            session = this.newSession(requestCycle.getRequest(), requestCycle.getResponse());
            ThreadContext.setSession(session);
            this.internalGetPageManager().newSessionCreated();
            this.sessionListeners.onCreated(session);
        } else {
            ThreadContext.setSession(session);
        }
        return session;
    }

    public final IRequestCycleProvider getRequestCycleProvider() {
        return this.requestCycleProvider;
    }

    public final void setRequestCycleProvider(IRequestCycleProvider requestCycleProvider) {
        this.requestCycleProvider = requestCycleProvider;
    }

    @Deprecated
    public IMarkupIdGenerator getMarkupIdGenerator() {
        return this.markupIdGenerator;
    }

    @Deprecated
    public void setMarkupIdGenerator(IMarkupIdGenerator markupIdGenerator) {
        this.markupIdGenerator = (IMarkupIdGenerator)Args.notNull((Object)markupIdGenerator, (String)"markupIdGenerator");
    }

    public final RequestCycle createRequestCycle(Request request, Response response) {
        RequestCycleContext context = new RequestCycleContext(request, response, this.getRootRequestMapper(), (IExceptionMapper)this.getExceptionMapperProvider().get());
        RequestCycle requestCycle = (RequestCycle)this.getRequestCycleProvider().get(context);
        requestCycle.getListeners().add(this.requestCycleListeners);
        requestCycle.getListeners().add(new AbstractRequestCycleListener(){

            @Override
            public void onDetach(RequestCycle requestCycle) {
                if (Session.exists()) {
                    Session.get().getPageManager().commitRequest();
                }
            }

            @Override
            public void onEndRequest(RequestCycle cycle) {
                IRequestLogger requestLogger;
                if (Application.exists() && (requestLogger = Application.get().getRequestLogger()) != null) {
                    requestLogger.requestTime(System.currentTimeMillis() - cycle.getStartTime());
                }
            }
        });
        return requestCycle;
    }

    public final void setHeaderResponseDecorator(IHeaderResponseDecorator headerResponseDecorator) {
        this.headerResponseDecorator = headerResponseDecorator;
    }

    public final IHeaderResponse decorateHeaderResponse(IHeaderResponse response) {
        ResourceAggregator aggregatingResponse = new ResourceAggregator(response);
        if (this.headerResponseDecorator == null) {
            return aggregatingResponse;
        }
        return this.headerResponseDecorator.decorate(aggregatingResponse);
    }

    public final boolean usesDevelopmentConfig() {
        return RuntimeConfigurationType.DEVELOPMENT.equals((Object)this.getConfigurationType());
    }

    public final boolean usesDeploymentConfig() {
        return RuntimeConfigurationType.DEPLOYMENT.equals((Object)this.getConfigurationType());
    }

    private static class DefaultRequestCycleProvider
    implements IRequestCycleProvider {
        private DefaultRequestCycleProvider() {
        }

        public RequestCycle get(RequestCycleContext context) {
            return new RequestCycle(context);
        }
    }

    private static class DefaultExceptionMapperProvider
    implements IProvider<IExceptionMapper> {
        private DefaultExceptionMapperProvider() {
        }

        public IExceptionMapper get() {
            return new DefaultExceptionMapper();
        }
    }
}

