/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.util.io.IClusterable;

public abstract class MetaDataKey<T>
implements IClusterable {
    private static final long serialVersionUID = 1L;

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public T get(MetaDataEntry<?>[] metaData) {
        if (metaData != null) {
            for (MetaDataEntry<?> entry : metaData) {
                if (!this.equals(entry.key)) continue;
                return (T)entry.object;
            }
        }
        return null;
    }

    public MetaDataEntry<?>[] set(MetaDataEntry<?>[] metaData, Object object) {
        boolean set = false;
        if (metaData != null) {
            for (int i = 0; i < metaData.length; ++i) {
                MetaDataEntry<?> m = metaData[i];
                if (!this.equals(m.key)) continue;
                if (object != null) {
                    m.object = object;
                } else if (metaData.length > 1) {
                    int l = metaData.length - 1;
                    MetaDataEntry[] newMetaData = new MetaDataEntry[l];
                    System.arraycopy(metaData, 0, newMetaData, 0, i);
                    System.arraycopy(metaData, i + 1, newMetaData, i, l - i);
                    metaData = newMetaData;
                } else {
                    metaData = null;
                }
                set = true;
                break;
            }
        }
        if (!set && object != null) {
            MetaDataEntry m = new MetaDataEntry(this, object);
            if (metaData == null) {
                metaData = new MetaDataEntry[]{m};
            } else {
                MetaDataEntry[] newMetaData = new MetaDataEntry[metaData.length + 1];
                System.arraycopy(metaData, 0, newMetaData, 0, metaData.length);
                newMetaData[metaData.length] = m;
                metaData = newMetaData;
            }
        }
        return metaData;
    }

    public String toString() {
        return this.getClass().toString();
    }
}

