/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import org.apache.openjpa.event.LifecycleCallbacks;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class MethodLifecycleCallbacks
implements LifecycleCallbacks,
Externalizable {
    private static final Localizer _loc = Localizer.forPackage(MethodLifecycleCallbacks.class);
    private transient Method _callback;
    private boolean _arg;

    public MethodLifecycleCallbacks(Class cls, String method, boolean arg) {
        Class[] classArray;
        if (arg) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Object.class;
        } else {
            classArray = null;
        }
        Class[] args = classArray;
        this._callback = MethodLifecycleCallbacks.getMethod(cls, method, args);
        this._arg = arg;
    }

    public MethodLifecycleCallbacks(Method method, boolean arg) {
        this._callback = method;
        this._arg = arg;
    }

    public Method getCallbackMethod() {
        return this._callback;
    }

    public boolean requiresArgument() {
        return this._arg;
    }

    @Override
    public boolean hasCallback(Object obj, int eventType) {
        return true;
    }

    @Override
    public void makeCallback(Object obj, Object arg, int eventType) throws Exception {
        if (!this._callback.isAccessible()) {
            AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction((AccessibleObject)this._callback, (boolean)true));
        }
        if (this._arg) {
            this._callback.invoke(obj, arg);
        } else {
            this._callback.invoke(obj, (Object[])null);
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this._callback;
    }

    protected static Method getMethod(Class cls, String method, Class[] args) {
        Class currentClass = cls;
        do {
            Method[] methods = (Method[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction((Class)currentClass));
            for (int i = 0; i < methods.length; ++i) {
                if (!method.equals(methods[i].getName()) || !MethodLifecycleCallbacks.isAssignable(methods[i].getParameterTypes(), args)) continue;
                return methods[i];
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        throw new UserException(_loc.get("method-notfound", (Object)cls.getName(), (Object)method, args == null ? null : Arrays.asList(args)));
    }

    private static boolean isAssignable(Class[] from, Class[] to) {
        if (from == null) {
            return to == null || to.length == 0;
        }
        if (to == null) {
            return from == null || from.length == 0;
        }
        if (from.length != to.length) {
            return false;
        }
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == null || from[i].isAssignableFrom(to[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Class[] classArray;
        Class cls = (Class)in.readObject();
        String methName = (String)in.readObject();
        this._arg = in.readBoolean();
        if (this._arg) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Object.class;
        } else {
            classArray = null;
        }
        Class[] args = classArray;
        this._callback = MethodLifecycleCallbacks.getMethod(cls, methName, args);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._callback.getClass());
        out.writeObject(this._callback.getName());
        out.writeBoolean(this._arg);
    }
}

