/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URLConnection;
import java.util.Properties;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.cocoon.pipeline.PipelineException;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.xml.sax.EmbeddedSAXPipe;
import org.apache.cocoon.xml.sax.SAXBuffer;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XMLUtils {
    private static final SAXTransformerFactory SAX_TRANSFORMER_FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();

    public static void toOutputStream(OutputStream outputStream, SAXBuffer saxBuffer) {
        try {
            TransformerHandler transformerHandler = SAX_TRANSFORMER_FACTORY.newTransformerHandler();
            Properties properties = new Properties();
            properties.put("method", "xml");
            transformerHandler.getTransformer().setOutputProperties(properties);
            transformerHandler.setResult(new StreamResult(outputStream));
            transformerHandler.startDocument();
            saxBuffer.toSAX((ContentHandler)new EmbeddedSAXPipe((ContentHandler)transformerHandler));
            transformerHandler.endDocument();
        }
        catch (Exception e) {
            throw new ProcessingException("Can't stream the provided SaxBuffer.", (Throwable)e);
        }
    }

    public static void toSax(InputStream inputStream, ContentHandler contentHandler) throws IOException, SAXException {
        XMLUtils.createXMLReader(contentHandler).parse(new InputSource(new BufferedInputStream(inputStream)));
    }

    public static void toSax(String string, ContentHandler contentHandler) throws IOException, SAXException {
        XMLUtils.createXMLReader(contentHandler).parse(new InputSource(new StringReader(string)));
    }

    public static void toSax(URLConnection urlConnection, ContentHandler contentHandler) {
        try {
            InputStream inputStream = urlConnection.getInputStream();
            XMLUtils.toSax(inputStream, contentHandler);
        }
        catch (PipelineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException("Can't parse url connection " + urlConnection.getURL(), (Throwable)e);
        }
        finally {
            URLConnectionUtils.closeQuietly((URLConnection)urlConnection);
        }
    }

    public static XMLReader createXMLReader(ContentHandler contentHandler) {
        XMLReader xmlReader;
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(contentHandler);
            if (contentHandler instanceof LexicalHandler) {
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
            }
            xmlReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new ByteArrayInputStream("".getBytes()));
                }
            });
        }
        catch (SAXException e) {
            throw new ProcessingException("Cannot create and prepare an XMLReader.", (Throwable)e);
        }
        return xmlReader;
    }
}

