/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.executor.loader.JavassistProxyFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;

class JavassistSerialStateHolder
implements Externalizable {
    private static final long serialVersionUID = 8940388717901644661L;
    private static final ThreadLocal<ObjectOutputStream> stream = new ThreadLocal();
    private byte[] userBeanBytes = new byte[0];
    private Object userBean;
    private String[] unloadedProperties;
    private ObjectFactory objectFactory;
    private Class<?>[] constructorArgTypes;
    private Object[] constructorArgs;

    public JavassistSerialStateHolder() {
    }

    public JavassistSerialStateHolder(Object userBean, Set<String> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        this.userBean = userBean;
        this.unloadedProperties = unloadedProperties.toArray(new String[unloadedProperties.size()]);
        this.objectFactory = objectFactory;
        this.constructorArgTypes = constructorArgTypes.toArray(new Class[constructorArgTypes.size()]);
        this.constructorArgs = constructorArgs.toArray(new Object[constructorArgs.size()]);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean firstRound = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = stream.get();
        if (os == null) {
            os = new ObjectOutputStream(baos);
            firstRound = true;
            stream.set(os);
        }
        os.writeObject(this.userBean);
        os.writeObject(this.unloadedProperties);
        os.writeObject(this.objectFactory);
        os.writeObject(this.constructorArgTypes);
        os.writeObject(this.constructorArgs);
        byte[] bytes = baos.toByteArray();
        out.writeObject(bytes);
        if (firstRound) {
            stream.remove();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object data = in.readObject();
        if (data.getClass().isArray()) {
            this.userBeanBytes = (byte[])data;
        } else {
            this.userBean = data;
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.userBean != null && this.userBeanBytes.length == 0) {
            return this.userBean;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.userBeanBytes));
            this.userBean = in.readObject();
            this.unloadedProperties = (String[])in.readObject();
            this.objectFactory = (ObjectFactory)in.readObject();
            this.constructorArgTypes = (Class[])in.readObject();
            this.constructorArgs = (Object[])in.readObject();
        }
        catch (IOException ex) {
            throw (ObjectStreamException)new StreamCorruptedException().initCause(ex);
        }
        catch (ClassNotFoundException ex) {
            throw (ObjectStreamException)new InvalidClassException(ex.getLocalizedMessage()).initCause(ex);
        }
        HashSet<String> arrayProps = new HashSet<String>(Arrays.asList(this.unloadedProperties));
        List<Class<?>> arrayTypes = Arrays.asList(this.constructorArgTypes);
        List<Object> arrayValues = Arrays.asList(this.constructorArgs);
        return new JavassistProxyFactory().createDeserializationProxy(this.userBean, arrayProps, this.objectFactory, arrayTypes, arrayValues);
    }
}

