/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionParams;

public final class PDFEncryptionManager {
    private static final Log LOG = LogFactory.getLog(PDFEncryptionManager.class);

    private PDFEncryptionManager() {
    }

    public static boolean isJCEAvailable() {
        try {
            Class.forName("javax.crypto.Cipher");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean checkAvailableAlgorithms() {
        if (!PDFEncryptionManager.isJCEAvailable()) {
            return false;
        }
        Provider[] providers = Security.getProviders("Cipher.RC4");
        if (providers == null) {
            LOG.warn((Object)"Cipher provider for RC4 not available.");
            return false;
        }
        providers = Security.getProviders("MessageDigest.MD5");
        if (providers == null) {
            LOG.warn((Object)"MessageDigest provider for MD5 not available.");
            return false;
        }
        return true;
    }

    public static void setupPDFEncryption(PDFEncryptionParams params, PDFDocument pdf) {
        if (pdf == null) {
            throw new NullPointerException("PDF document must not be null");
        }
        if (params != null) {
            if (!PDFEncryptionManager.checkAvailableAlgorithms()) {
                if (PDFEncryptionManager.isJCEAvailable()) {
                    LOG.warn((Object)"PDF encryption has been requested, JCE is available but there's no JCE provider available that provides the necessary algorithms. The PDF won't be encrypted.");
                } else {
                    LOG.warn((Object)"PDF encryption has been requested but JCE is unavailable! The PDF won't be encrypted.");
                }
            }
            pdf.setEncryption(params);
        }
    }

    public static PDFEncryption newInstance(int objnum, PDFEncryptionParams params, PDFDocument pdf) {
        try {
            Class<?> clazz = Class.forName("org.apache.fop.pdf.PDFEncryptionJCE");
            Method makeMethod = clazz.getMethod("make", Integer.TYPE, PDFEncryptionParams.class, PDFDocument.class);
            Object obj = makeMethod.invoke(null, new Integer(objnum), params, pdf);
            return (PDFEncryption)obj;
        }
        catch (ClassNotFoundException e) {
            if (PDFEncryptionManager.checkAvailableAlgorithms()) {
                LOG.warn((Object)"JCE and algorithms available, but the implementation class unavailable. Please do a full rebuild.");
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e);
            return null;
        }
    }
}

