/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.util.ArrayList;
import java.util.List;
import org.identityconnectors.common.logging.Log;

public final class ThreadClassLoaderManager {
    private static final Log LOG = Log.getLog(ThreadClassLoaderManager.class);
    private static final ThreadLocal<ThreadClassLoaderManager> INSTANCE = new ThreadLocal<ThreadClassLoaderManager>(){

        @Override
        public ThreadClassLoaderManager initialValue() {
            return new ThreadClassLoaderManager();
        }
    };
    private final List<ClassLoader> _loaderStack = new ArrayList<ClassLoader>();

    private ThreadClassLoaderManager() {
    }

    public static ThreadClassLoaderManager getInstance() {
        return INSTANCE.get();
    }

    public static void clearInstance() {
        INSTANCE.remove();
    }

    public void pushClassLoader(ClassLoader loader) {
        this._loaderStack.add(this.getCurrentClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
    }

    public void popClassLoader() {
        if (this._loaderStack.isEmpty()) {
            throw new IllegalStateException("Stack size is 0");
        }
        ClassLoader previous = this._loaderStack.remove(this._loaderStack.size() - 1);
        Thread.currentThread().setContextClassLoader(previous);
    }

    public List<ClassLoader> popAll() {
        ArrayList<ClassLoader> rv = new ArrayList<ClassLoader>(this._loaderStack);
        while (!this._loaderStack.isEmpty()) {
            this.popClassLoader();
        }
        return rv;
    }

    public void pushAll(List<ClassLoader> loaders) {
        for (ClassLoader loader : loaders) {
            this.pushClassLoader(loader);
        }
    }

    public ClassLoader getCurrentClassLoader() {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (result == null) {
            LOG.error(new Throwable(), "The CCL of current thread ''{0}'' is null", new Object[]{Thread.currentThread().getName()});
        }
        return result;
    }
}

