/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.search.NodeCond;
import org.apache.syncope.common.services.UserService;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.PropagationRequestTO;
import org.apache.syncope.common.to.UserTO;
import org.springframework.web.client.RestTemplate;

public class UserServiceProxy
extends SpringServiceProxy
implements UserService {
    public UserServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public int count() {
        return (Integer)this.getRestTemplate().getForObject(this.baseUrl + "user/count.json", Integer.class, new Object[0]);
    }

    public List<UserTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "user/list.json", UserTO[].class, new Object[0]));
    }

    public List<UserTO> list(int page, int size) {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "user/list/{page}/{size}.json", UserTO[].class, new Object[]{page, size}));
    }

    public UserTO read(Long userId) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/read/{userId}.json", UserTO.class, new Object[]{userId});
    }

    public UserTO read(String username) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/readByUsername/{username}.json", UserTO.class, new Object[]{username});
    }

    public Response create(UserTO userTO) {
        UserTO created = (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/create", (Object)userTO, UserTO.class, new Object[0]);
        URI location = URI.create(this.baseUrl + "user/read/" + created.getId() + ".json");
        return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)created.getId()).entity((Object)created).build();
    }

    public UserTO update(Long userId, UserMod userMod) {
        userMod.setId(userId.longValue());
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/update", (Object)userMod, UserTO.class, new Object[0]);
    }

    public UserTO delete(Long userId) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/delete/{userId}", UserTO.class, new Object[]{userId});
    }

    public UserTO activate(long userId, String token) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/activate/{userId}?token=" + token, UserTO.class, new Object[]{userId});
    }

    public UserTO activate(long userId, String token, PropagationRequestTO propagationRequestTO) {
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/activate/{userId}?token=" + token, (Object)propagationRequestTO, UserTO.class, new Object[]{userId});
    }

    public UserTO activateByUsername(String username, String token) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/activateByUsername/{username}.json?token=" + token, UserTO.class, new Object[]{username});
    }

    public UserTO activateByUsername(String username, String token, PropagationRequestTO propagationRequestTO) {
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/activateByUsername/{username}.json?token=" + token, (Object)propagationRequestTO, UserTO.class, new Object[]{username});
    }

    public UserTO suspend(long userId) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/suspend/{userId}", UserTO.class, new Object[]{userId});
    }

    public UserTO suspend(long userId, PropagationRequestTO propagationRequestTO) {
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/suspend/{userId}", (Object)propagationRequestTO, UserTO.class, new Object[]{userId});
    }

    public UserTO suspendByUsername(String username) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/suspendByUsername/{username}.json", UserTO.class, new Object[]{username});
    }

    public UserTO suspendByUsername(String username, PropagationRequestTO propagationRequestTO) {
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/suspendByUsername/{username}.json", (Object)propagationRequestTO, UserTO.class, new Object[]{username});
    }

    public UserTO reactivate(long userId) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/reactivate/{userId}", UserTO.class, new Object[]{userId});
    }

    public UserTO reactivate(long userId, PropagationRequestTO propagationRequestTO) {
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/reactivate/{userId}", (Object)propagationRequestTO, UserTO.class, new Object[]{userId});
    }

    public UserTO reactivateByUsername(String username) {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/reactivateByUsername/{username}.json", UserTO.class, new Object[]{username});
    }

    public UserTO reactivateByUsername(String username, PropagationRequestTO propagationRequestTO) {
        return (UserTO)this.getRestTemplate().postForObject(this.baseUrl + "user/reactivateByUsername/{username}.json", (Object)propagationRequestTO, UserTO.class, new Object[]{username});
    }

    public UserTO readSelf() {
        return (UserTO)this.getRestTemplate().getForObject(this.baseUrl + "user/read/self", UserTO.class, new Object[0]);
    }

    public List<UserTO> search(NodeCond searchCondition) {
        return Arrays.asList((Object[])this.getRestTemplate().postForObject(this.baseUrl + "user/search", (Object)searchCondition, UserTO[].class, new Object[0]));
    }

    public List<UserTO> search(NodeCond searchCondition, int page, int size) {
        return Arrays.asList((Object[])this.getRestTemplate().postForObject(this.baseUrl + "user/search/{page}/{size}", (Object)searchCondition, UserTO[].class, new Object[]{page, size}));
    }

    public int searchCount(NodeCond searchCondition) {
        return (Integer)this.getRestTemplate().postForObject(this.baseUrl + "user/search/count.json", (Object)searchCondition, Integer.class, new Object[0]);
    }

    public BulkActionRes bulkAction(BulkAction bulkAction) {
        return (BulkActionRes)this.getRestTemplate().postForObject(this.baseUrl + "user/bulk", (Object)bulkAction, BulkActionRes.class, new Object[0]);
    }
}

