/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.syncope.client.http.PreemptiveAuthHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public abstract class SpringServiceProxy {
    protected String baseUrl;
    private RestTemplate restTemplate;

    public SpringServiceProxy(String baseUrl, RestTemplate restTemplate) {
        this.baseUrl = baseUrl;
        this.restTemplate = restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected Response handleStream(String url) {
        AuthScope scope = ((PreemptiveAuthHttpRequestFactory)this.getRestTemplate().getRequestFactory()).getAuthScope();
        HttpHost targetHost = new HttpHost(scope.getHost(), scope.getPort(), scope.getScheme());
        BasicHttpContext localcontext = new BasicHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targetHost, (AuthScheme)new BasicScheme());
        localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
        HttpGet getMethod = new HttpGet(url);
        try {
            Response response;
            HttpResponse httpResponse = ((PreemptiveAuthHttpRequestFactory)this.getRestTemplate().getRequestFactory()).getHttpClient().execute(targetHost, (HttpRequest)getMethod, (HttpContext)localcontext);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = httpResponse.getEntity();
                response = Response.ok((Object)entity.getContent(), (String)entity.getContentType().getValue()).header("Content-Disposition", (Object)httpResponse.getLastHeader("Content-Disposition").getValue()).build();
            } else {
                response = Response.noContent().status(httpResponse.getStatusLine().getStatusCode()).build();
            }
            return response;
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected Collection<String> handlePossiblyEmptyStringCollection(String url) {
        Collection<String> result = Collections.emptySet();
        Object object = this.getRestTemplate().getForObject(url, Object.class, new Object[0]);
        if (object instanceof String) {
            String string = (String)object;
            result = Collections.singleton(string);
        } else if (object instanceof Collection) {
            result = (Collection)object;
        }
        return result;
    }
}

