/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.ConfigurationService;
import org.apache.syncope.common.to.ConfigurationTO;
import org.apache.syncope.common.to.MailTemplateTO;
import org.apache.syncope.common.to.ValidatorTO;
import org.apache.syncope.common.util.CollectionWrapper;
import org.springframework.web.client.RestTemplate;

public class ConfigurationServiceProxy
extends SpringServiceProxy
implements ConfigurationService {
    public ConfigurationServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public Response create(ConfigurationTO configurationTO) {
        ConfigurationTO created = (ConfigurationTO)this.getRestTemplate().postForObject(this.baseUrl + "configuration/create", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
        try {
            URI location = URI.create(this.baseUrl + "configuration/read/" + URLEncoder.encode(created.getKey(), "UTF-8") + ".json");
            return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)created.getKey()).build();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void delete(String key) {
        this.getRestTemplate().getForObject(this.baseUrl + "configuration/delete/{key}.json", ConfigurationTO.class, new Object[]{key});
    }

    public List<ConfigurationTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "configuration/list.json", ConfigurationTO[].class, new Object[0]));
    }

    public ConfigurationTO read(String key) {
        return (ConfigurationTO)this.getRestTemplate().getForObject(this.baseUrl + "configuration/read/{key}.json", ConfigurationTO.class, new Object[]{key});
    }

    public void update(String key, ConfigurationTO configurationTO) {
        this.getRestTemplate().postForObject(this.baseUrl + "configuration/update", (Object)configurationTO, ConfigurationTO.class, new Object[0]);
    }

    public Set<ValidatorTO> getValidators() {
        return CollectionWrapper.wrapValidators(this.handlePossiblyEmptyStringCollection(this.baseUrl + "configuration/validators.json"));
    }

    public Set<MailTemplateTO> getMailTemplates() {
        return CollectionWrapper.wrapMailTemplates(this.handlePossiblyEmptyStringCollection(this.baseUrl + "configuration/mailTemplates.json"));
    }

    public Response dbExport() {
        return this.handleStream(this.baseUrl + "configuration/dbexport");
    }
}

