/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.datacache.ConcurrentDataCache;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class PartitionedDataCache
extends ConcurrentDataCache {
    private static final Localizer _loc = Localizer.forPackage(PartitionedDataCache.class);
    private Class<? extends DataCache> _type = ConcurrentDataCache.class;
    private final List<String> _partProperties = new ArrayList<String>();
    private final Map<String, DataCache> _partitions = new HashMap<String, DataCache>();

    @Override
    public void initialize(DataCacheManager mgr) {
        super.initialize(mgr);
        for (DataCache part : this._partitions.values()) {
            part.initialize(mgr);
        }
    }

    public void setPartitionType(String type) throws Exception {
        Value value = this.conf.getValue("DataCache");
        ClassLoader ctxLoader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        ClassLoader loader = this.conf.getClassResolverInstance().getClassLoader(null, ctxLoader);
        this._type = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)value.unalias(type), (boolean)true, (ClassLoader)loader));
    }

    public void setPartitions(String parts) {
        DataCache[] array;
        this._partProperties.clear();
        this.parsePartitionProperties(parts);
        PluginListValue partitions = new PluginListValue("partitions");
        Object[] types = (String[])Array.newInstance(String.class, this._partProperties.size());
        Arrays.fill(types, this._type.getName());
        partitions.setClassNames((String[])types);
        partitions.setProperties(this._partProperties.toArray(new String[this._partProperties.size()]));
        for (DataCache part : array = (DataCache[])partitions.instantiate(this._type, (Configuration)this.conf)) {
            if (part.getName() == null) {
                throw new UserException(_loc.get("partition-cache-null-partition", (Object)parts));
            }
            if (this._partitions.containsKey(part.getName())) {
                throw new UserException(_loc.get("partition-cache-duplicate-partition", (Object)part.getName(), (Object)parts));
            }
            if (part.getName().equals("default")) {
                throw new UserException(_loc.get("partition-cache-default-partition", (Object)part.getName(), (Object)parts));
            }
            this._partitions.put(part.getName(), part);
        }
    }

    public List<String> getPartitions() {
        return this._partProperties;
    }

    @Override
    public DataCache getPartition(String name, boolean create) {
        return this._partitions.get(name);
    }

    @Override
    public Set<String> getPartitionNames() {
        return this._partitions.keySet();
    }

    @Override
    public final boolean isPartitioned() {
        return !this._partitions.isEmpty();
    }

    @Override
    public void endConfiguration() {
        if (!this.isPartitioned()) {
            this.conf.getConfigurationLog().warn((Object)_loc.get("partition-cache-no-config"));
        }
    }

    private void parsePartitionProperties(String full) {
        int i;
        for (String properties = new String(full); properties != null && (properties = properties.trim()).length() != 0; properties = properties.substring(i + 1)) {
            if (properties.startsWith(",")) {
                properties = properties.substring(1);
            } else if (!this._partProperties.isEmpty()) {
                throw new UserException(_loc.get("partition-cache-parse-error-comma", (Object)full, (Object)properties));
            }
            if (properties.startsWith("(") && properties.endsWith(")")) {
                i = properties.indexOf(")");
                String p = properties.substring(1, i);
                this._partProperties.add(p);
                if (i >= properties.length() - 1) break;
                continue;
            }
            throw new UserException(_loc.get("partition-cache-parse-error-paren", (Object)full, (Object)properties));
        }
    }
}

