/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.IOSpecification;
import org.activiti.bpmn.model.Lane;

public class Process
extends BaseElement
implements FlowElementsContainer,
HasExecutionListeners {
    protected String name;
    protected boolean executable = true;
    protected String documentation;
    protected IOSpecification ioSpecification;
    protected List<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
    protected List<Lane> lanes = new ArrayList<Lane>();
    protected List<FlowElement> flowElementList = new ArrayList<FlowElement>();
    protected Map<String, FlowElement> flowElementMap = new HashMap<String, FlowElement>();
    protected List<Artifact> artifactList = new ArrayList<Artifact>();
    protected List<String> candidateStarterUsers = new ArrayList<String>();
    protected List<String> candidateStarterGroups = new ArrayList<String>();

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    @Override
    public List<ActivitiListener> getExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public void setExecutionListeners(List<ActivitiListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public void setLanes(List<Lane> lanes) {
        this.lanes = lanes;
    }

    @Override
    public FlowElement getFlowElement(String flowElementId) {
        FlowElement flowElement = this.flowElementMap.get(flowElementId);
        if (flowElement == null) {
            flowElement = this.findFlowElementInList(flowElementId);
        }
        return flowElement;
    }

    protected FlowElement findFlowElementInList(String flowElementId) {
        for (FlowElement f : this.flowElementList) {
            if (f.getId() == null || !f.getId().equals(flowElementId)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return this.flowElementList;
    }

    @Override
    public void addFlowElement(FlowElement element) {
        this.flowElementList.add(element);
        this.flowElementMap.put(element.getId(), element);
    }

    @Override
    public void removeFlowElement(String elementId) {
        FlowElement element = this.flowElementMap.get(elementId);
        if (element == null) {
            element = this.findFlowElementInList(elementId);
        }
        if (element != null) {
            this.flowElementList.remove(element);
            this.flowElementMap.remove(elementId);
        }
    }

    @Override
    public Artifact getArtifact(String id) {
        Artifact foundArtifact = null;
        for (Artifact artifact : this.artifactList) {
            if (!id.equals(artifact.getId())) continue;
            foundArtifact = artifact;
            break;
        }
        return foundArtifact;
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return this.artifactList;
    }

    @Override
    public void addArtifact(Artifact artifact) {
        this.artifactList.add(artifact);
    }

    @Override
    public void removeArtifact(String artifactId) {
        Artifact artifact = this.getArtifact(artifactId);
        if (artifact != null) {
            this.artifactList.remove(artifact);
        }
    }

    public List<String> getCandidateStarterUsers() {
        return this.candidateStarterUsers;
    }

    public void setCandidateStarterUsers(List<String> candidateStarterUsers) {
        this.candidateStarterUsers = candidateStarterUsers;
    }

    public List<String> getCandidateStarterGroups() {
        return this.candidateStarterGroups;
    }

    public void setCandidateStarterGroups(List<String> candidateStarterGroups) {
        this.candidateStarterGroups = candidateStarterGroups;
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsOfType(Class<FlowElementType> type) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        for (FlowElement flowElement : this.getFlowElements()) {
            if (!type.isInstance(flowElement)) continue;
            flowElements.add(flowElement);
        }
        return flowElements;
    }
}

