/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;

public class BookmarkableMapper
extends AbstractBookmarkableMapper {
    private final IPageParametersEncoder pageParametersEncoder;

    public BookmarkableMapper(IPageParametersEncoder pageParametersEncoder) {
        Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.pageParametersEncoder = pageParametersEncoder;
    }

    public BookmarkableMapper() {
        this((IPageParametersEncoder)new PageParametersEncoder());
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        url.getSegments().add(this.getContext().getNamespace());
        url.getSegments().add(this.getContext().getBookmarkableIdentifier());
        url.getSegments().add(info.getPageClass().getName());
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        if (this.matches(request)) {
            Url url = request.getUrl();
            PageComponentInfo info = this.getPageComponentInfo(url);
            List segments = url.getSegments();
            String className = segments.size() >= 3 ? (String)segments.get(2) : (String)segments.get(1);
            Class<? extends IRequestablePage> pageClass = this.getPageClass(className);
            if (pageClass != null && IRequestablePage.class.isAssignableFrom(pageClass)) {
                Url reverseUrl;
                Application application;
                if (Application.exists() && (application = Application.get()).getSecuritySettings().getEnforceMounts() && !pageClass.equals(application.getHomePage()) && !this.matches(request.cloneWithUrl(reverseUrl = application.getRootRequestMapper().mapHandler((IRequestHandler)new RenderPageRequestHandler(new PageProvider(pageClass)))))) {
                    return null;
                }
                PageParameters pageParameters = this.extractPageParameters(request, 3, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = 0;
        if (this.matches(request)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Request request) {
        boolean matches = false;
        Url url = request.getUrl();
        Url baseUrl = request.getClientUrl();
        String namespace = this.getContext().getNamespace();
        String bookmarkableIdentifier = this.getContext().getBookmarkableIdentifier();
        String pageIdentifier = this.getContext().getPageIdentifier();
        if (url.getSegments().size() >= 3 && this.urlStartsWith(url, new String[]{namespace, bookmarkableIdentifier})) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 3 && this.urlStartsWith(baseUrl, new String[]{namespace, bookmarkableIdentifier}) && url.getSegments().size() >= 2 && this.urlStartsWith(url, new String[]{bookmarkableIdentifier})) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, new String[]{bookmarkableIdentifier}) && url.getSegments().size() == 2 && this.urlStartsWith(url, new String[]{bookmarkableIdentifier})) {
            matches = true;
        } else if (baseUrl.getSegments().size() == 2 && this.urlStartsWith(baseUrl, new String[]{namespace, pageIdentifier}) && url.getSegments().size() >= 2 && this.urlStartsWith(url, new String[]{bookmarkableIdentifier})) {
            matches = true;
        }
        return matches;
    }
}

