/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class AjaxFormValidatingBehavior
extends AjaxFormSubmitBehavior {
    private static final long serialVersionUID = 1L;

    public AjaxFormValidatingBehavior(Form<?> form, String event) {
        super(form, event);
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target) {
        this.addFeedbackPanels(target);
    }

    @Override
    protected void onError(AjaxRequestTarget target) {
        this.addFeedbackPanels(target);
    }

    private void addFeedbackPanels(final AjaxRequestTarget target) {
        this.getComponent().getPage().visitChildren(IFeedback.class, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                target.add(component);
            }
        });
    }

    public static void addToAllFormComponents(Form<?> form, String event) {
        AjaxFormValidatingBehavior.addToAllFormComponents(form, event, null);
    }

    public static void addToAllFormComponents(Form<?> form, String event, Duration throttleDelay) {
        form.visitChildren(FormComponent.class, new FormValidateVisitor(form, event, throttleDelay));
    }

    private static class FormValidateVisitor
    implements IVisitor<Component, Void>,
    IClusterable {
        private final Form<?> form;
        private final String event;
        private final Duration throttleDelay;

        private FormValidateVisitor(Form<?> form, String event, Duration throttleDelay) {
            this.form = form;
            this.event = event;
            this.throttleDelay = throttleDelay;
        }

        public void component(final Component component, IVisit<Void> visit) {
            AjaxFormValidatingBehavior behavior = new AjaxFormValidatingBehavior(this.form, this.event){

                @Override
                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    if (FormValidateVisitor.this.throttleDelay != null) {
                        String id = "throttle-" + component.getMarkupId();
                        ThrottlingSettings throttlingSettings = new ThrottlingSettings(id, FormValidateVisitor.this.throttleDelay);
                        attributes.setThrottlingSettings(throttlingSettings);
                    }
                    attributes.setAllowDefault(true);
                }
            };
            component.add(behavior);
            visit.dontGoDeeper();
        }
    }
}

