/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.pooling;

import java.util.LinkedHashMap;

public final class ObjectPoolConfiguration {
    private int _maxObjects = 10;
    private int _maxIdle = 10;
    private long _maxWait = 150000L;
    private long _minEvictableIdleTimeMillis = 120000L;
    private int _minIdle = 1;

    public int getMaxObjects() {
        return this._maxObjects;
    }

    public void setMaxObjects(int maxObjects) {
        this._maxObjects = maxObjects;
    }

    public int getMaxIdle() {
        return this._maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this._maxIdle = maxIdle;
    }

    public long getMaxWait() {
        return this._maxWait;
    }

    public void setMaxWait(long maxWait) {
        this._maxWait = maxWait;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public int getMinIdle() {
        return this._minIdle;
    }

    public void setMinIdle(int minIdle) {
        this._minIdle = minIdle;
    }

    public void validate() {
        if (this._minIdle < 0) {
            throw new IllegalStateException("Min idle is less than zero.");
        }
        if (this._maxObjects < 0) {
            throw new IllegalStateException("Max active is less than zero.");
        }
        if (this._maxIdle < 0) {
            throw new IllegalStateException("Max idle is less than zero.");
        }
        if (this._maxWait < 0L) {
            throw new IllegalStateException("Max wait is less than zero.");
        }
        if (this._minEvictableIdleTimeMillis < 0L) {
            throw new IllegalStateException("Min evictable idle time millis less than zero.");
        }
        if (this._minIdle > this._maxIdle) {
            throw new IllegalStateException("Min idle is greater than max idle.");
        }
        if (this._maxIdle > this._maxObjects) {
            throw new IllegalStateException("Max idle is greater than max objects.");
        }
    }

    public int hashCode() {
        return (int)((long)(this.getMaxObjects() + this.getMaxIdle()) + this.getMaxWait() + this.getMinEvictableIdleTimeMillis() + (long)this.getMinIdle());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectPoolConfiguration) {
            ObjectPoolConfiguration other = (ObjectPoolConfiguration)obj;
            if (this.getMaxObjects() != other.getMaxObjects()) {
                return false;
            }
            if (this.getMaxIdle() != other.getMaxIdle()) {
                return false;
            }
            if (this.getMaxWait() != other.getMaxWait()) {
                return false;
            }
            if (this.getMinEvictableIdleTimeMillis() != other.getMinEvictableIdleTimeMillis()) {
                return false;
            }
            return this.getMinIdle() == other.getMinIdle();
        }
        return false;
    }

    public String toString() {
        LinkedHashMap<String, Number> bld = new LinkedHashMap<String, Number>();
        bld.put("MaxObjects", this.getMaxObjects());
        bld.put("MaxIdle", this.getMaxIdle());
        bld.put("MaxWait", this.getMaxWait());
        bld.put("MinEvictableIdleTimeMillis", this.getMinEvictableIdleTimeMillis());
        bld.put("MinIdle", this.getMinIdle());
        return ((Object)bld).toString();
    }
}

