/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.ReflectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.LogSpi;
import org.identityconnectors.common.logging.StdOutLogger;

public final class Log {
    private static Class<?> defaultSPI = StdOutLogger.class;
    private static final String PACKAGE = ReflectionUtil.getPackage(Log.class);
    public static final String LOGSPI_PROP = PACKAGE + ".class";
    public static final String LOGSPI_PROPS_FILE = "connectors.properties";
    private static Class<?> cacheSPI;
    private final Class<?> _clazz;
    private final LogSpi _logImpl;

    private Log(Class<?> clazz, LogSpi logImpl) {
        this._clazz = clazz;
        this._logImpl = logImpl;
    }

    static Log getLog(Class<?> clazz, LogSpi logImpl) {
        return new Log(clazz, logImpl);
    }

    public static Log getLog(Class<?> clazz) {
        try {
            if (LogSpi.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
            LogSpi logImpl = (LogSpi)Log.getSpiClass().newInstance();
            return new Log(clazz, logImpl);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLoggable(Level level) {
        return this._logImpl.isLoggable(this._clazz, level);
    }

    public void log(Class<?> clazz, String method, Level level, String message, Throwable ex) {
        if (this.isLoggable(level)) {
            this._logImpl.log(clazz, method, level, message, ex);
        }
    }

    public void log(Level level, Throwable ex, String format, Object ... args) {
        if (this.isLoggable(level)) {
            String message = format;
            if (format != null && args != null) {
                message = MessageFormat.format(format, args);
            } else if (format == null && ex != null) {
                message = ex.getLocalizedMessage();
            }
            String methodName = ReflectionUtil.getMethodName(3);
            this.log(this._clazz, methodName, level, message, ex);
        }
    }

    public void ok(Throwable ex, String format, Object ... args) {
        this.log(Level.OK, ex, format, args);
    }

    public void info(Throwable ex, String format, Object ... args) {
        this.log(Level.INFO, ex, format, args);
    }

    public void warn(Throwable ex, String format, Object ... args) {
        this.log(Level.WARN, ex, format, args);
    }

    public void error(Throwable ex, String format, Object ... args) {
        this.log(Level.ERROR, ex, format, args);
    }

    public void ok(String format, Object ... args) {
        this.log(Level.OK, null, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(Level.INFO, null, format, args);
    }

    public void warn(String format, Object ... args) {
        this.log(Level.WARN, null, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(Level.ERROR, null, format, args);
    }

    public boolean isOk() {
        return this.isLoggable(Level.OK);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARN);
    }

    public boolean isError() {
        return this.isLoggable(Level.ERROR);
    }

    private static Class<?> findSpiClass() {
        String serviceId;
        String clazz;
        String impl = System.getProperty(LOGSPI_PROP);
        if (StringUtil.isNotBlank(impl)) {
            return Log.forName(impl);
        }
        File javaHome = new File(System.getProperty("java.home"));
        File javaHomeLib = new File(javaHome, "lib");
        File propsFile = new File(javaHomeLib, LOGSPI_PROPS_FILE);
        if (propsFile.isFile() && propsFile.canRead()) {
            FileInputStream fis;
            block7: {
                Class<?> clazz2;
                fis = null;
                try {
                    Properties props = new Properties();
                    fis = new FileInputStream(propsFile);
                    props.load(fis);
                    String prop = props.getProperty(LOGSPI_PROP);
                    if (!StringUtil.isNotBlank(prop)) break block7;
                    clazz2 = Log.forName(prop);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.quietClose(fis);
                        throw throwable;
                    }
                }
                IOUtil.quietClose(fis);
                return clazz2;
            }
            IOUtil.quietClose(fis);
        }
        if (StringUtil.isNotBlank(clazz = IOUtil.getResourceAsString(Log.class, serviceId = "META-INF/services/" + PACKAGE))) {
            return Log.forName(clazz.trim());
        }
        return defaultSPI;
    }

    private static Class<?> forName(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> getSpiClass() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (cacheSPI == null) {
                cacheSPI = Log.findSpiClass();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheSPI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSpiClass(Class<?> clazz) {
        Class<Log> clazz2 = Log.class;
        synchronized (Log.class) {
            cacheSPI = clazz;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static enum Level {
        OK,
        INFO,
        WARN,
        ERROR;

    }
}

