/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class EqualsHashCodeBuilder {
    private final List<Object> _members = new ArrayList<Object>();

    public EqualsHashCodeBuilder append(Object object) {
        if (object != null && object.getClass().isArray()) {
            EqualsHashCodeBuilder bld = new EqualsHashCodeBuilder();
            if (object instanceof long[]) {
                for (long l : (long[])object) {
                    bld.append(l);
                }
            } else if (object instanceof int[]) {
                for (int i : (int[])object) {
                    bld.append(i);
                }
            } else if (object instanceof short[]) {
                for (short o : (short[])object) {
                    bld.append(o);
                }
            } else if (object instanceof char[]) {
                for (char o : (char[])object) {
                    bld.append(Character.valueOf(o));
                }
            } else if (object instanceof byte[]) {
                for (byte o : (byte[])object) {
                    bld.append(o);
                }
            } else if (object instanceof double[]) {
                for (double o : (double[])object) {
                    bld.append(o);
                }
            } else if (object instanceof float[]) {
                for (float o : (float[])object) {
                    bld.append(Float.valueOf(o));
                }
            } else if (object instanceof boolean[]) {
                for (boolean o : (boolean[])object) {
                    bld.append(o);
                }
            } else {
                for (Object o : (Object[])object) {
                    bld.append(o);
                }
            }
            this._members.add(bld);
        } else if (object instanceof Set || object instanceof List) {
            this._members.add(object);
        } else {
            if (object instanceof Collection) {
                String ERR = "Collections are not accepted!";
                throw new IllegalArgumentException("Collections are not accepted!");
            }
            this._members.add(object);
        }
        return this;
    }

    public void appendBean(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object must not be null!");
        }
        Class<?> clazz = obj.getClass();
        for (Method m : clazz.getMethods()) {
            String name;
            if (m.getModifiers() != 1 || m.getReturnType() == Void.class || !(name = m.getName()).startsWith("get") || Character.isLowerCase(name.charAt(3))) continue;
            try {
                clazz.getMethod("s" + name.substring(1), m.getReturnType());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            try {
                this.append(m.invoke(obj, new Object[0]));
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof EqualsHashCodeBuilder) {
            EqualsHashCodeBuilder bld = (EqualsHashCodeBuilder)obj;
            ret = this._members.equals(bld._members);
        }
        return ret;
    }

    public int hashCode() {
        return this._members.hashCode();
    }

    public String toString() {
        return this._members.toString();
    }
}

