/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.scripting.Resolver;
import org.activiti.engine.impl.scripting.ResolverFactory;
import org.activiti.engine.impl.scripting.ScriptBindings;

public class ScriptBindingsFactory {
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    public Bindings createBindings(VariableScope variableScope) {
        return new ScriptBindings(this.createResolvers(variableScope), variableScope);
    }

    public Bindings createBindings(VariableScope variableScope, boolean storeScriptVariables) {
        return new ScriptBindings(this.createResolvers(variableScope), variableScope, storeScriptVariables);
    }

    protected List<Resolver> createResolvers(VariableScope variableScope) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(variableScope);
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return scriptResolvers;
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

