/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.history;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryManager
extends AbstractManager {
    private static Logger log = LoggerFactory.getLogger((String)HistoryManager.class.getName());
    private HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();

    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        if (log.isDebugEnabled()) {
            log.debug("Current history level: {}, level required: {}", (Object)this.historyLevel, (Object)level);
        }
        return this.historyLevel.isAtLeast(level);
    }

    public boolean isHistoryEnabled() {
        if (log.isDebugEnabled()) {
            log.debug("Current history level: {}", (Object)this.historyLevel);
        }
        return !this.historyLevel.equals((Object)HistoryLevel.NONE);
    }

    public void recordProcessInstanceEnd(String processInstanceId, String deleteReason, String activityId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = this.getHistoricProcessInstanceManager().findHistoricProcessInstance(processInstanceId)) != null) {
            historicProcessInstance.markEnded(deleteReason);
            historicProcessInstance.setEndActivityId(activityId);
        }
    }

    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricProcessInstanceEntity historicProcessInstance = new HistoricProcessInstanceEntity(processInstance);
            this.getDbSqlSession().insert(historicProcessInstance);
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            String processDefinitionId = processInstance.getProcessDefinitionId();
            String processInstanceId = processInstance.getProcessInstanceId();
            String executionId = processInstance.getId();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(processDefinitionId);
            historicActivityInstance.setProcessInstanceId(processInstanceId);
            historicActivityInstance.setExecutionId(executionId);
            historicActivityInstance.setActivityId(processInstance.getActivityId());
            historicActivityInstance.setActivityName((String)processInstance.getActivity().getProperty("name"));
            historicActivityInstance.setActivityType((String)processInstance.getActivity().getProperty("type"));
            Date now = ClockUtil.getCurrentTime();
            historicActivityInstance.setStartTime(now);
            this.getDbSqlSession().insert(historicActivityInstance);
        }
    }

    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricProcessInstanceEntity historicProcessInstance = new HistoricProcessInstanceEntity(subProcessInstance);
            ActivityImpl initialActivity = subProcessInstance.getActivity();
            if (historicProcessInstance.getStartActivityId() == null) {
                historicProcessInstance.setStartActivityId(subProcessInstance.getProcessDefinition().getInitial().getId());
                initialActivity = subProcessInstance.getProcessDefinition().getInitial();
            }
            this.getDbSqlSession().insert(historicProcessInstance);
            HistoricActivityInstanceEntity activitiyInstance = this.findActivityInstance(parentExecution);
            if (activitiyInstance != null) {
                activitiyInstance.setCalledProcessInstanceId(subProcessInstance.getProcessInstanceId());
            }
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(subProcessInstance.getProcessDefinitionId());
            historicActivityInstance.setProcessInstanceId(subProcessInstance.getProcessInstanceId());
            historicActivityInstance.setExecutionId(subProcessInstance.getId());
            historicActivityInstance.setActivityId(initialActivity.getId());
            historicActivityInstance.setActivityName((String)initialActivity.getProperty("name"));
            historicActivityInstance.setActivityType((String)initialActivity.getProperty("type"));
            Date now = ClockUtil.getCurrentTime();
            historicActivityInstance.setStartTime(now);
            this.getDbSqlSession().insert(historicActivityInstance);
        }
    }

    public void recordActivityStart(ExecutionEntity executionEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity.getActivity() != null) {
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            String processDefinitionId = executionEntity.getProcessDefinitionId();
            String processInstanceId = executionEntity.getProcessInstanceId();
            String executionId = executionEntity.getId();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(processDefinitionId);
            historicActivityInstance.setProcessInstanceId(processInstanceId);
            historicActivityInstance.setExecutionId(executionId);
            historicActivityInstance.setActivityId(executionEntity.getActivityId());
            historicActivityInstance.setActivityName((String)executionEntity.getActivity().getProperty("name"));
            historicActivityInstance.setActivityType((String)executionEntity.getActivity().getProperty("type"));
            historicActivityInstance.setStartTime(ClockUtil.getCurrentTime());
            this.getDbSqlSession().insert(historicActivityInstance);
        }
    }

    public void recordActivityEnd(ExecutionEntity executionEntity) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicActivityInstance = this.findActivityInstance(executionEntity)) != null) {
            historicActivityInstance.markEnded(null);
        }
    }

    public void recordStartEventEnded(String executionId, String activityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            if (activityId == null) {
                return;
            }
            List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
            for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
                if (!executionId.equals(cachedHistoricActivityInstance.getExecutionId()) || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null) continue;
                cachedHistoricActivityInstance.markEnded(null);
                return;
            }
        }
    }

    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution) {
        String executionId = execution.getId();
        String activityId = execution.getActivityId();
        List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (!executionId.equals(cachedHistoricActivityInstance.getExecutionId()) || activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null) continue;
            return cachedHistoricActivityInstance;
        }
        List historicActivityInstances = new HistoricActivityInstanceQueryImpl(Context.getCommandContext()).executionId(executionId).activityId(activityId).unfinished().listPage(0, 1);
        if (!historicActivityInstances.isEmpty()) {
            return (HistoricActivityInstanceEntity)historicActivityInstances.get(0);
        }
        if (execution.getParentId() != null) {
            return this.findActivityInstance(execution.getParent());
        }
        return null;
    }

    public void recordExecutionReplacedBy(ExecutionEntity execution, InterpretableExecution replacedBy) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getDbSqlSession().findInCache(HistoricActivityInstanceEntity.class);
            for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
                if (cachedHistoricActivityInstance.getEndTime() != null || !execution.getId().equals(cachedHistoricActivityInstance.getExecutionId())) continue;
                cachedHistoricActivityInstance.setExecutionId(replacedBy.getId());
            }
            List historicActivityInstances = new HistoricActivityInstanceQueryImpl(Context.getCommandContext()).executionId(execution.getId()).unfinished().list();
            for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
                historicActivityInstance.setExecutionId(replacedBy.getId());
            }
        }
    }

    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = this.getHistoricProcessInstanceManager().findHistoricProcessInstance(processInstanceId)) != null) {
            historicProcessInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskInstanceEntity historicTaskInstance = new HistoricTaskInstanceEntity(task, execution);
            this.getDbSqlSession().insert(historicTaskInstance);
        }
    }

    public void recordTaskAssignment(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity executionEntity = task.getExecution();
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity != null && (historicActivityInstance = this.findActivityInstance(executionEntity)) != null) {
            historicActivityInstance.setAssignee(task.getAssignee());
        }
    }

    public void recordTaskClaim(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setClaimTime(ClockUtil.getCurrentTime());
        }
    }

    public void recordTaskId(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity execution;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (execution = task.getExecution()) != null && (historicActivityInstance = this.findActivityInstance(execution)) != null) {
            historicActivityInstance.setTaskId(task.getId());
        }
    }

    public void recordTaskEnd(String taskId, String deleteReason) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.markEnded(deleteReason);
        }
    }

    public void recordTaskAssigneeChange(String taskId, String assignee) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setAssignee(assignee);
        }
    }

    public void recordTaskOwnerChange(String taskId, String owner) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setOwner(owner);
        }
    }

    public void recordTaskNameChange(String taskId, String taskName) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setName(taskName);
        }
    }

    public void recordTaskDescriptionChange(String taskId, String description) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setDescription(description);
        }
    }

    public void recordTaskDueDateChange(String taskId, Date dueDate) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setDueDate(dueDate);
        }
    }

    public void recordTaskPriorityChange(String taskId, int priority) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setPriority(priority);
        }
    }

    public void recordTaskParentTaskIdChange(String taskId, String parentTaskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setParentTaskId(parentTaskId);
        }
    }

    public void recordTaskExecutionIdChange(String taskId, String executionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setExecutionId(executionId);
        }
    }

    public void recordTaskDefinitionKeyChange(TaskEntity task, String taskDefinitionKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, task.getId())) != null) {
            Object formValue;
            TaskFormHandler taskFormHandler;
            historicTaskInstance.setTaskDefinitionKey(taskDefinitionKey);
            if (taskDefinitionKey != null && (taskFormHandler = task.getTaskDefinition().getTaskFormHandler()) != null && taskFormHandler.getFormKey() != null && (formValue = taskFormHandler.getFormKey().getValue(task.getExecution())) != null) {
                historicTaskInstance.setFormKey(formValue.toString());
            }
        }
    }

    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity.copyAndInsert(variable);
        }
    }

    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            HistoricActivityInstanceEntity historicActivityInstance;
            HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = HistoricDetailVariableInstanceUpdateEntity.copyAndInsert(variable);
            if (useActivityId && sourceActivityExecution != null && (historicActivityInstance = this.findActivityInstance(sourceActivityExecution)) != null) {
                historicVariableUpdate.setActivityInstanceId(historicActivityInstance.getId());
            }
        }
    }

    public void recordVariableUpdate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getDbSqlSession().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = Context.getCommandContext().getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                historicProcessVariable.copyValue(variable);
            } else {
                HistoricVariableInstanceEntity.copyAndInsert(variable);
            }
        }
    }

    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, userId, groupId, type, create, false);
    }

    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(ClockUtil.getCurrentTime());
            comment.setTaskId(taskId);
            if (userId != null || forceNullUserId) {
                if (create) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getSession(CommentEntityManager.class).insert(comment);
        }
    }

    public void createAttachmentComment(String taskId, String processInstanceId, String attachmentName, boolean create) {
        if (this.isHistoryEnabled()) {
            String userId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(userId);
            comment.setType("event");
            comment.setTime(ClockUtil.getCurrentTime());
            comment.setTaskId(taskId);
            comment.setProcessInstanceId(processInstanceId);
            if (create) {
                comment.setAction("AddAttachment");
            } else {
                comment.setAction("DeleteAttachment");
            }
            comment.setMessage(attachmentName);
            this.getSession(CommentEntityManager.class).insert(comment);
        }
    }

    public void reportFormPropertiesSubmitted(ExecutionEntity processInstance, Map<String, String> properties, String taskId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                HistoricFormPropertyEntity historicFormProperty = new HistoricFormPropertyEntity(processInstance, propertyId, propertyValue, taskId);
                this.getDbSqlSession().insert(historicFormProperty);
            }
        }
    }

    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkEntity historicIdentityLinkEntity = new HistoricIdentityLinkEntity(identityLink);
            this.getDbSqlSession().insert(historicIdentityLinkEntity);
        }
    }

    public void deleteHistoricIdentityLink(String id) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLink(id);
        }
    }

    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance;
            if (log.isDebugEnabled()) {
                log.debug("updateProcessBusinessKeyInHistory : {}", (Object)processInstance.getId());
            }
            if (processInstance != null && (historicProcessInstance = this.getDbSqlSession().selectById(HistoricProcessInstanceEntity.class, processInstance.getId())) != null) {
                historicProcessInstance.setBusinessKey(processInstance.getProcessBusinessKey());
                this.getDbSqlSession().update(historicProcessInstance);
            }
        }
    }
}

