/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class SubmitTaskFormCmd
extends NeedsActiveTaskCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, String> properties;
    protected boolean completeTask;

    public SubmitTaskFormCmd(String taskId, Map<String, String> properties, boolean completeTask) {
        super(taskId);
        this.taskId = taskId;
        this.properties = properties;
        this.completeTask = completeTask;
    }

    @Override
    protected Object execute(CommandContext commandContext, TaskEntity task) {
        commandContext.getHistoryManager().reportFormPropertiesSubmitted(task.getExecution(), this.properties, this.taskId);
        TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
        taskFormHandler.submitFormProperties(this.properties, task.getExecution());
        if (this.completeTask) {
            task.complete();
        }
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot submit a form to a suspended task";
    }
}

