/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;

public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AttachmentEntity attachment = commandContext.getDbSqlSession().selectById(AttachmentEntity.class, this.attachmentId);
        commandContext.getDbSqlSession().delete(attachment);
        if (attachment.getContentId() != null) {
            commandContext.getByteArrayEntityManager().deleteByteArrayById(attachment.getContentId());
        }
        if (attachment.getTaskId() != null) {
            commandContext.getHistoryManager().createAttachmentComment(attachment.getTaskId(), attachment.getProcessInstanceId(), attachment.getName(), false);
        }
        return null;
    }
}

