/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.HashMap;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessParseHandler
extends AbstractBpmnParseHandler<Process> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessParseHandler.class);
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return Process.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, Process process) {
        if (!process.isExecutable()) {
            LOGGER.info("Ignoring non-executable process with id='" + process.getId() + "'. Set the attribute isExecutable=\"true\" to deploy this process.");
        } else {
            bpmnParse.getProcessDefinitions().add(this.transformProcess(bpmnParse, process));
        }
    }

    protected ProcessDefinitionEntity transformProcess(BpmnParse bpmnParse, Process process) {
        ProcessDefinitionEntity currentProcessDefinition = new ProcessDefinitionEntity();
        bpmnParse.setCurrentProcessDefinition(currentProcessDefinition);
        currentProcessDefinition.setKey(process.getId());
        currentProcessDefinition.setName(process.getName());
        currentProcessDefinition.setCategory(bpmnParse.getBpmnModel().getTargetNamespace());
        currentProcessDefinition.setDescription(process.getDocumentation());
        currentProcessDefinition.setProperty(PROPERTYNAME_DOCUMENTATION, process.getDocumentation());
        currentProcessDefinition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        currentProcessDefinition.setDeploymentId(bpmnParse.getDeployment().getId());
        this.createExecutionListenersOnScope(bpmnParse, process.getExecutionListeners(), currentProcessDefinition);
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        for (String candidateUser : process.getCandidateStarterUsers()) {
            currentProcessDefinition.addCandidateStarterUserIdExpression(expressionManager.createExpression(candidateUser));
        }
        for (String candidateGroup : process.getCandidateStarterGroups()) {
            currentProcessDefinition.addCandidateStarterGroupIdExpression(expressionManager.createExpression(candidateGroup));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing process {}", (Object)currentProcessDefinition.getKey());
        }
        bpmnParse.setCurrentScope(currentProcessDefinition);
        bpmnParse.processFlowElements(process.getFlowElements());
        this.processArtifacts(bpmnParse, process.getArtifacts(), currentProcessDefinition);
        bpmnParse.removeCurrentScope();
        if (process.getIoSpecification() != null) {
            IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, process.getIoSpecification());
            currentProcessDefinition.setIoSpecification(ioSpecification);
        }
        return currentProcessDefinition;
    }
}

