/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.apache.commons.lang3.StringUtils;

public class IntermediateThrowEventParseHandler
extends AbstractActivityBpmnParseHandler<ThrowEvent> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ThrowEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ThrowEvent intermediateEvent) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        ActivityImpl nestedActivityImpl = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)intermediateEvent, "intermediateThrowEvent");
        EventDefinition eventDefinition = null;
        if (intermediateEvent.getEventDefinitions().size() > 0) {
            eventDefinition = (EventDefinition)intermediateEvent.getEventDefinitions().get(0);
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else if (eventDefinition instanceof org.activiti.bpmn.model.CompensateEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else if (eventDefinition == null) {
            nestedActivityImpl.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateThrowNoneEventActivityBehavior(intermediateEvent));
        } else {
            bpmnModel.addProblem("Unsupported intermediate throw event type " + eventDefinition, (BaseElement)intermediateEvent);
        }
    }

    protected CompensateEventDefinition createCompensateEventDefinition(BpmnParse bpmnParse, org.activiti.bpmn.model.CompensateEventDefinition eventDefinition, ScopeImpl scopeElement) {
        if (StringUtils.isNotEmpty((CharSequence)eventDefinition.getActivityRef()) && scopeElement.findActivity(eventDefinition.getActivityRef()) == null) {
            bpmnParse.getBpmnModel().addProblem("Invalid attribute value for 'activityRef': no activity with id '" + eventDefinition.getActivityRef() + "' in current scope " + scopeElement.getId(), (BaseElement)eventDefinition);
        }
        CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
        compensateEventDefinition.setActivityRef(eventDefinition.getActivityRef());
        compensateEventDefinition.setWaitForCompletion(eventDefinition.isWaitForCompletion());
        return compensateEventDefinition;
    }
}

