/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class EventBasedGatewayParseHandler
extends AbstractActivityBpmnParseHandler<EventGateway> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return EventGateway.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, EventGateway gateway) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)gateway, "eventBasedGateway");
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createEventBasedGatewayActivityBehavior(gateway));
        activity.setScope(true);
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        for (SequenceFlow sequenceFlow : gateway.getOutgoingFlows()) {
            FlowElement flowElement = bpmnModel.getFlowElement(sequenceFlow.getTargetRef());
            if (flowElement == null || flowElement instanceof IntermediateCatchEvent) continue;
            bpmnModel.addProblem("Event based gateway can only be connected to elements of type intermediateCatchEvent.", (BaseElement)flowElement);
        }
    }
}

