/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.apache.commons.lang3.StringUtils;

public class SequenceFlowXMLConverter
extends BaseBpmnXMLConverter {
    public static String getXMLType() {
        return "sequenceFlow";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return SequenceFlow.class;
    }

    @Override
    protected String getXMLElementName() {
        return "sequenceFlow";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        SequenceFlow sequenceFlow = new SequenceFlow();
        BpmnXMLUtil.addXMLLocation((BaseElement)sequenceFlow, xtr);
        sequenceFlow.setSourceRef(xtr.getAttributeValue(null, "sourceRef"));
        sequenceFlow.setTargetRef(xtr.getAttributeValue(null, "targetRef"));
        sequenceFlow.setName(xtr.getAttributeValue(null, "name"));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)sequenceFlow, xtr);
        return sequenceFlow;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
        SequenceFlow sequenceFlow = (SequenceFlow)element;
        this.writeDefaultAttribute("sourceRef", sequenceFlow.getSourceRef(), xtw);
        this.writeDefaultAttribute("targetRef", sequenceFlow.getTargetRef(), xtw);
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        SequenceFlow sequenceFlow = (SequenceFlow)element;
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
            xtw.writeStartElement("conditionExpression");
            xtw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "tFormalExpression");
            xtw.writeCData(sequenceFlow.getConditionExpression());
            xtw.writeEndElement();
        }
    }
}

