/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.components.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.spring.annotations.BusinessKey;
import org.activiti.spring.annotations.ProcessVariable;
import org.activiti.spring.annotations.StartProcess;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProcessStartingMethodInterceptor
implements MethodInterceptor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected ProcessEngine processEngine;

    public ProcessStartingMethodInterceptor(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    boolean shouldReturnProcessInstance(StartProcess startProcess, MethodInvocation methodInvocation, Object result) {
        return result instanceof ProcessInstance || methodInvocation.getMethod().getReturnType().isAssignableFrom(ProcessInstance.class);
    }

    boolean shouldReturnProcessInstanceId(StartProcess startProcess, MethodInvocation methodInvocation, Object result) {
        return startProcess.returnProcessInstanceId() && (result instanceof String || methodInvocation.getMethod().getReturnType().isAssignableFrom(String.class));
    }

    boolean shouldReturnAsyncResultWithProcessInstance(StartProcess startProcess, MethodInvocation methodInvocation, Object result) {
        return result instanceof Future || methodInvocation.getMethod().getReturnType().isAssignableFrom(Future.class);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        Method method = invocation.getMethod();
        StartProcess startProcess = (StartProcess)AnnotationUtils.getAnnotation((Method)method, StartProcess.class);
        String processKey = startProcess.processKey();
        Assert.hasText((String)processKey, (String)"you must provide the name of process to start");
        try {
            ProcessInstance pi;
            result = invocation.proceed();
            Map<String, Object> vars = this.processVariablesFromAnnotations(invocation);
            String businessKey = this.processBusinessKey(invocation);
            this.log.info("variables for the started process: {}", (Object)vars.toString());
            RuntimeService runtimeService = this.processEngine.getRuntimeService();
            if (null != businessKey && StringUtils.hasText((String)businessKey)) {
                pi = runtimeService.startProcessInstanceByKey(processKey, businessKey, vars);
                this.log.info("the business key for the started process is '{}'", (Object)businessKey);
            } else {
                pi = runtimeService.startProcessInstanceByKey(processKey, vars);
            }
            String pId = pi.getId();
            if (invocation.getMethod().getReturnType().equals(Void.TYPE)) {
                return null;
            }
            if (this.shouldReturnProcessInstance(startProcess, invocation, result)) {
                return pi;
            }
            if (this.shouldReturnProcessInstanceId(startProcess, invocation, result)) {
                return pId;
            }
            if (this.shouldReturnAsyncResultWithProcessInstance(startProcess, invocation, result)) {
                return new AsyncResult((Object)pi);
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return result;
    }

    protected String processBusinessKey(MethodInvocation invocation) throws Throwable {
        Map businessKeyAnnotations = this.mapOfAnnotationValues(BusinessKey.class, invocation);
        if (businessKeyAnnotations.size() == 1) {
            BusinessKey processId = businessKeyAnnotations.keySet().iterator().next();
            return (String)businessKeyAnnotations.get(processId);
        }
        return null;
    }

    private <K extends Annotation, V> Map<K, V> mapOfAnnotationValues(Class<K> annotationType, MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Annotation[][] annotations = method.getParameterAnnotations();
        HashMap<Annotation, Object> vars = new HashMap<Annotation, Object>();
        int paramIndx = 0;
        Annotation[][] arr$ = annotations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annPerParam;
            for (Annotation annotation : annPerParam = arr$[i$]) {
                if (!annotationType.isAssignableFrom(annotation.getClass())) continue;
                Annotation pv = annotation;
                Object v = invocation.getArguments()[paramIndx];
                vars.put(pv, v);
            }
            ++paramIndx;
        }
        return vars;
    }

    protected Map<String, Object> processVariablesFromAnnotations(MethodInvocation invocation) throws Throwable {
        Map vars = this.mapOfAnnotationValues(ProcessVariable.class, invocation);
        HashMap<String, Object> varNameToValueMap = new HashMap<String, Object>();
        for (ProcessVariable processVariable : vars.keySet()) {
            varNameToValueMap.put(processVariable.value(), vars.get(processVariable));
        }
        return varNameToValueMap;
    }
}

