/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server;

import java.io.File;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.LogManager;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.server.ConnectorServer;

public final class Main {
    private static final String PROP_PORT = "connectorserver.port";
    private static final String PROP_BUNDLE_DIR = "connectorserver.bundleDir";
    private static final String PROP_LIB_DIR = "connectorserver.libDir";
    private static final String PROP_SSL = "connectorserver.usessl";
    private static final String PROP_IFADDRESS = "connectorserver.ifaddress";
    private static final String PROP_KEY = "connectorserver.key";
    private static final String PROP_LOGGER_CLASS = "connectorserver.loggerClass";
    private static final String DEFAULT_LOG_SPI = "org.identityconnectors.common.logging.StdOutLogger";
    private static ConnectorServer _server;
    private static Log _log;

    private static void usage() {
        System.out.println("Usage: Main -run -properties <connectorserver.properties>");
        System.out.println("       Main -setKey -key <key> -properties <connectorserver.properties>");
        System.out.println("       Main -setDefaults -properties <connectorserver.properties>");
        System.out.println("NOTE: If using SSL, you must specify the system config");
        System.out.println("    properties: ");
        System.out.println("        -Djavax.net.ssl.keyStore");
        System.out.println("        -Djavax.net.ssl.keyStoreType (optional)");
        System.out.println("        -Djavax.net.ssl.keyStorePassword");
    }

    public static void main(String[] args) throws Exception {
        Properties properties;
        if (args.length == 0 || args.length % 2 != 1) {
            Main.usage();
            return;
        }
        String propertiesFileName = null;
        String key = null;
        for (int i = 1; i < args.length; i += 2) {
            String name = args[i];
            String value = args[i + 1];
            if (name.equalsIgnoreCase("-properties")) {
                propertiesFileName = value;
                continue;
            }
            if (name.equalsIgnoreCase("-key")) {
                key = value;
                continue;
            }
            Main.usage();
            return;
        }
        String cmd = args[0];
        if (cmd.equalsIgnoreCase("-run")) {
            if (propertiesFileName == null || key != null) {
                Main.usage();
                return;
            }
            properties = IOUtil.loadPropertiesFile(propertiesFileName);
            Main.run(properties);
        } else if (cmd.equalsIgnoreCase("-setkey")) {
            if (propertiesFileName == null || key == null) {
                Main.usage();
                return;
            }
            properties = IOUtil.loadPropertiesFile((String)propertiesFileName);
            properties.put(PROP_KEY, SecurityUtil.computeBase64SHA1Hash((char[])key.toCharArray()));
            IOUtil.storePropertiesFile((File)new File(propertiesFileName), (Properties)properties);
        } else if (cmd.equalsIgnoreCase("-setDefaults")) {
            if (propertiesFileName == null || key != null) {
                Main.usage();
                return;
            }
            IOUtil.extractResourceToFile(Main.class, (String)"connectorserver.properties", (File)new File(propertiesFileName));
        } else {
            Main.usage();
            return;
        }
    }

    private static void run(Properties properties) throws Exception {
        if (_server != null) {
            System.err.println("Server has already been started");
        }
        String portStr = properties.getProperty(PROP_PORT);
        String bundleDirStr = properties.getProperty(PROP_BUNDLE_DIR);
        String libDirStr = properties.getProperty(PROP_LIB_DIR);
        String useSSLStr = properties.getProperty(PROP_SSL);
        String ifAddress = properties.getProperty(PROP_IFADDRESS);
        String keyHash = properties.getProperty(PROP_KEY);
        String loggerClass = properties.getProperty(PROP_LOGGER_CLASS);
        if (portStr == null) {
            throw new ConnectorException("connectorserver.properties is missing connectorserver.port");
        }
        if (bundleDirStr == null) {
            throw new ConnectorException("connectorserver.properties is missing connectorserver.bundleDir");
        }
        if (keyHash == null) {
            throw new ConnectorException("connectorserver.properties is missing connectorserver.key");
        }
        if (loggerClass == null) {
            loggerClass = DEFAULT_LOG_SPI;
        }
        Main.ensureLoggingNotInitialized();
        System.setProperty(Log.LOGSPI_PROP, loggerClass);
        int port = Integer.parseInt(portStr);
        if (Thread.currentThread().getContextClassLoader() == null) {
            Main.getLog().warn("Context class loader is null, working around", new Object[0]);
            Thread.currentThread().setContextClassLoader(Main.class.getClassLoader());
        }
        _server = ConnectorServer.newInstance();
        _server.setPort(port);
        _server.setBundleURLs(Main.buildBundleURLs(new File(bundleDirStr)));
        if (libDirStr != null) {
            _server.setBundleParentClassLoader(Main.buildLibClassLoader(new File(libDirStr)));
        }
        _server.setKeyHash(keyHash);
        if (useSSLStr != null) {
            boolean useSSL = Boolean.parseBoolean(useSSLStr);
            _server.setUseSSL(useSSL);
        }
        if (ifAddress != null) {
            _server.setIfAddress(InetAddress.getByName(ifAddress));
        }
        _server.start();
        Main.getLog().info("Connector server listening on port " + port, new Object[0]);
        _server.awaitStop();
    }

    public static void stop(String[] args) {
        if (_server == null) {
            System.err.println("Server has not been started yet");
            return;
        }
        if (Thread.currentThread().getContextClassLoader() == null) {
            Main.getLog().warn("Context class loader is null, working around", new Object[0]);
            Thread.currentThread().setContextClassLoader(Main.class.getClassLoader());
        }
        _server.stop();
        Main.getLog().info("Connector server stopped", new Object[0]);
        LogManager.getLogManager().reset();
    }

    private static void ensureLoggingNotInitialized() throws Exception {
        Field field = Log.class.getDeclaredField("_cacheSpi");
        field.setAccessible(true);
        if (field.get(null) != null) {
            throw new IllegalStateException("Logging has already been initialized");
        }
    }

    private static List<URL> buildBundleURLs(File dir) throws MalformedURLException {
        List<URL> rv = Main.getJarFiles(dir);
        if (rv.isEmpty()) {
            Main.getLog().warn("No bundles found in the bundles directory", new Object[0]);
        }
        return rv;
    }

    private static ClassLoader buildLibClassLoader(File dir) throws MalformedURLException {
        List<URL> jars = Main.getJarFiles(dir);
        if (!jars.isEmpty()) {
            return new URLClassLoader(jars.toArray(new URL[jars.size()]), ConnectorInfoManagerFactory.class.getClassLoader());
        }
        return null;
    }

    private static List<URL> getJarFiles(File dir) throws MalformedURLException {
        if (!dir.isDirectory()) {
            throw new ConnectorException(dir.getPath() + " does not exist");
        }
        ArrayList<URL> rv = new ArrayList<URL>();
        for (File bundle : dir.listFiles()) {
            if (!bundle.getName().endsWith(".jar")) continue;
            rv.add(bundle.toURI().toURL());
        }
        return rv;
    }

    private static synchronized Log getLog() {
        if (_log == null) {
            _log = Log.getLog(Main.class);
        }
        return _log;
    }
}

