/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.TaskService;
import org.apache.syncope.common.to.BulkAction;
import org.apache.syncope.common.to.BulkActionRes;
import org.apache.syncope.common.to.JobClassTO;
import org.apache.syncope.common.to.NotificationTaskTO;
import org.apache.syncope.common.to.PropagationTaskTO;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.common.to.SyncActionClassTO;
import org.apache.syncope.common.to.SyncTaskTO;
import org.apache.syncope.common.to.TaskExecTO;
import org.apache.syncope.common.to.TaskTO;
import org.apache.syncope.common.types.TaskType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class TaskServiceProxy
extends SpringServiceProxy
implements TaskService {
    public TaskServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public int count(TaskType type) {
        return (Integer)this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/count.json", Integer.class, new Object[]{type});
    }

    public Response create(TaskTO taskTO) {
        String subTypeString = taskTO instanceof SyncTaskTO ? "sync" : (taskTO instanceof SchedTaskTO ? "sched" : "");
        TaskTO task = (TaskTO)this.getRestTemplate().postForObject(this.baseUrl + "task/create/{type}", (Object)taskTO, taskTO.getClass(), new Object[]{subTypeString});
        return Response.created((URI)URI.create(this.baseUrl + "task/read/" + task.getId() + ".json")).header("org.apache.syncope.resource.id", (Object)task.getId()).build();
    }

    public void delete(Long taskId) {
        ClientHttpResponse response = null;
        try {
            ClientHttpRequest request = this.getRestTemplate().getRequestFactory().createRequest(URI.create(this.baseUrl + "task/delete/" + taskId), HttpMethod.GET);
            response = request.execute();
        }
        catch (IOException e) {
            throw new WebServiceException("Cannot send request to delete task " + taskId, (Throwable)e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void deleteExecution(Long executionId) {
        this.getRestTemplate().getForObject(this.baseUrl + "task/execution/delete/{executionId}.json", TaskExecTO.class, new Object[]{executionId});
    }

    public TaskExecTO execute(Long taskId, boolean dryRun) {
        String param = dryRun ? "?dryRun=true" : "";
        return (TaskExecTO)this.getRestTemplate().postForObject(this.baseUrl + "task/execute/{taskId}.json" + param, null, TaskExecTO.class, new Object[]{taskId});
    }

    public Set<JobClassTO> getJobClasses() {
        return CollectionWrapper.wrapJobClasses(this.handlePossiblyEmptyStringCollection(this.baseUrl + "task/jobClasses.json"));
    }

    public Set<SyncActionClassTO> getSyncActionsClasses() {
        return CollectionWrapper.wrapSyncActionClasses(this.handlePossiblyEmptyStringCollection(this.baseUrl + "task/syncActionsClasses.json"));
    }

    public List<? extends TaskTO> list(TaskType type) {
        switch (type) {
            case PROPAGATION: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list.json", PropagationTaskTO[].class, new Object[]{type}));
            }
            case NOTIFICATION: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list.json", NotificationTaskTO[].class, new Object[]{type}));
            }
            case SCHEDULED: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list.json", SchedTaskTO[].class, new Object[]{type}));
            }
            case SYNCHRONIZATION: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list.json", SyncTaskTO[].class, new Object[]{type}));
            }
        }
        throw new IllegalArgumentException("TaskType is not supported.");
    }

    public List<? extends TaskTO> list(TaskType type, int page, int size) {
        switch (type) {
            case PROPAGATION: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list/{page}/{size}.json", PropagationTaskTO[].class, new Object[]{type, page, size}));
            }
            case NOTIFICATION: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list/{page}/{size}.json", NotificationTaskTO[].class, new Object[]{type, page, size}));
            }
            case SCHEDULED: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list/{page}/{size}.json", SchedTaskTO[].class, new Object[]{type, page, size}));
            }
            case SYNCHRONIZATION: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "task/{type}/list/{page}/{size}.json", SyncTaskTO[].class, new Object[]{type, page, size}));
            }
        }
        throw new IllegalArgumentException("TaskType is not supported :" + type);
    }

    public <T extends TaskTO> T read(TaskType type, Long taskId) {
        return (T)((TaskTO)this.getRestTemplate().getForObject(this.baseUrl + "task/read/{taskId}.json", this.getTOClass(type), new Object[]{taskId}));
    }

    public TaskExecTO readExecution(Long executionId) {
        return (TaskExecTO)this.getRestTemplate().getForObject(this.baseUrl + "task/execution/read/{executionId}.json", TaskExecTO.class, new Object[]{executionId});
    }

    public void report(Long executionId, ReportExecTO report) {
        this.getRestTemplate().getForObject(this.baseUrl + "task/execution/report/{executionId}.json" + "?executionStatus={status}&message={message}", TaskExecTO.class, new Object[]{executionId, report.getStatus(), report.getMessage()});
    }

    public void update(Long taskId, TaskTO taskTO) {
        String path;
        String string = taskTO instanceof SyncTaskTO ? "sync" : (path = taskTO instanceof SchedTaskTO ? "sched" : null);
        if (path == null) {
            throw new IllegalArgumentException("Task can only be instance of SchedTaskTO or SyncTaskTO");
        }
        this.getRestTemplate().postForObject(this.baseUrl + "task/update/" + path, (Object)taskTO, taskTO.getClass(), new Object[0]);
    }

    private Class<? extends TaskTO> getTOClass(TaskType type) {
        switch (type) {
            case PROPAGATION: {
                return PropagationTaskTO.class;
            }
            case NOTIFICATION: {
                return NotificationTaskTO.class;
            }
            case SCHEDULED: {
                return SchedTaskTO.class;
            }
            case SYNCHRONIZATION: {
                return SyncTaskTO.class;
            }
        }
        throw new IllegalArgumentException("SchemaType is not supported: " + type);
    }

    public BulkActionRes bulkAction(BulkAction bulkAction) {
        return (BulkActionRes)this.getRestTemplate().postForObject(this.baseUrl + "task/bulk", (Object)bulkAction, BulkActionRes.class, new Object[0]);
    }
}

