/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.SchemaService;
import org.apache.syncope.common.to.AbstractSchemaTO;
import org.apache.syncope.common.to.DerivedSchemaTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.to.VirtualSchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.springframework.web.client.RestTemplate;

public class SchemaServiceProxy
extends SpringServiceProxy
implements SchemaService {
    public SchemaServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public <T extends AbstractSchemaTO> Response create(AttributableType kind, SchemaType type, T schemaTO) {
        AbstractSchemaTO schema = (AbstractSchemaTO)this.getRestTemplate().postForObject(this.baseUrl + type.toSpringURL() + "/{kind}/create", schemaTO, this.getTOClass(type), new Object[]{kind});
        try {
            URI location = URI.create(this.baseUrl + type.toSpringURL() + "/" + kind + "/read/" + URLEncoder.encode(schema.getName(), "UTF-8") + ".json");
            return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)schema.getName()).build();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void delete(AttributableType kind, SchemaType type, String schemaName) {
        this.getRestTemplate().getForObject(this.baseUrl + type.toSpringURL() + "/{kind}/delete/{name}.json", this.getTOClass(type), new Object[]{kind, schemaName});
    }

    public List<? extends AbstractSchemaTO> list(AttributableType kind, SchemaType type) {
        switch (type) {
            case NORMAL: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + type.toSpringURL() + "/{kind}/list.json", SchemaTO[].class, new Object[]{kind}));
            }
            case DERIVED: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + type.toSpringURL() + "/{kind}/list.json", DerivedSchemaTO[].class, new Object[]{kind}));
            }
            case VIRTUAL: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + type.toSpringURL() + "/{kind}/list.json", VirtualSchemaTO[].class, new Object[]{kind}));
            }
        }
        throw new IllegalArgumentException("SchemaType is not supported.");
    }

    public <T extends AbstractSchemaTO> T read(AttributableType kind, SchemaType type, String schemaName) {
        return (T)((AbstractSchemaTO)this.getRestTemplate().getForObject(this.baseUrl + type.toSpringURL() + "/{kind}/read/{name}.json", this.getTOClass(type), new Object[]{kind, schemaName}));
    }

    public <T extends AbstractSchemaTO> void update(AttributableType kind, SchemaType type, String schemaName, T schemaTO) {
        this.getRestTemplate().postForObject(this.baseUrl + type.toSpringURL() + "/{kind}/update", schemaTO, this.getTOClass(type), new Object[]{kind});
    }

    private Class<? extends AbstractSchemaTO> getTOClass(SchemaType type) {
        switch (type) {
            case NORMAL: {
                return SchemaTO.class;
            }
            case DERIVED: {
                return DerivedSchemaTO.class;
            }
            case VIRTUAL: {
                return VirtualSchemaTO.class;
            }
        }
        throw new IllegalArgumentException("SchemaType is not supported: " + type);
    }
}

