/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.ReportService;
import org.apache.syncope.common.services.ReportletConfClasses;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.ReportExecExportFormat;
import org.springframework.web.client.RestTemplate;

public class ReportServiceProxy
extends SpringServiceProxy
implements ReportService {
    public ReportServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public Response create(ReportTO reportTO) {
        ReportTO createdReportTO = (ReportTO)this.getRestTemplate().postForObject(this.baseUrl + "report/create", (Object)reportTO, ReportTO.class, new Object[0]);
        URI location = URI.create(this.baseUrl + "report/read/" + createdReportTO.getId() + ".json");
        return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)createdReportTO.getId()).build();
    }

    public void update(Long reportId, ReportTO reportTO) {
        this.getRestTemplate().postForObject(this.baseUrl + "report/update", (Object)reportTO, ReportTO.class, new Object[0]);
    }

    public int count() {
        return (Integer)this.getRestTemplate().getForObject(this.baseUrl + "report/count.json", Integer.class, new Object[0]);
    }

    public List<ReportTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "report/list", ReportTO[].class, new Object[0]));
    }

    public List<ReportTO> list(int page, int size) {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "report/list/{page}/{size}", ReportTO[].class, new Object[]{page, size}));
    }

    public ReportletConfClasses getReportletConfClasses() {
        return new ReportletConfClasses(this.handlePossiblyEmptyStringCollection(this.baseUrl + "report/reportletConfClasses.json"));
    }

    public ReportTO read(Long reportId) {
        return (ReportTO)this.getRestTemplate().getForObject(this.baseUrl + "report/read/{reportId}", ReportTO.class, new Object[]{reportId});
    }

    public ReportExecTO readExecution(Long executionId) {
        return (ReportExecTO)this.getRestTemplate().getForObject(this.baseUrl + "report/execution/read/{executionId}", ReportExecTO.class, new Object[]{executionId});
    }

    public Response exportExecutionResult(Long executionId, ReportExecExportFormat fmt) {
        String format = fmt == null ? "" : "?fmt=" + fmt.toString();
        return this.handleStream(this.baseUrl + "report/execution/export/" + executionId + format);
    }

    public ReportExecTO execute(Long reportId) {
        return (ReportExecTO)this.getRestTemplate().postForObject(this.baseUrl + "report/execute/{reportId}", null, ReportExecTO.class, new Object[]{reportId});
    }

    public void delete(Long reportId) {
        this.getRestTemplate().getForObject(this.baseUrl + "report/delete/{reportId}", ReportTO.class, new Object[]{reportId});
    }

    public void deleteExecution(Long executionId) {
        this.getRestTemplate().getForObject(this.baseUrl + "report/execution/delete/{executionId}", ReportExecTO.class, new Object[]{executionId});
    }
}

