/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.NotificationService;
import org.apache.syncope.common.to.NotificationTO;
import org.springframework.web.client.RestTemplate;

public class NotificationServiceProxy
extends SpringServiceProxy
implements NotificationService {
    public NotificationServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public Response create(NotificationTO notificationTO) {
        NotificationTO notification = (NotificationTO)this.getRestTemplate().postForObject(this.baseUrl + "notification/create.json", (Object)notificationTO, NotificationTO.class, new Object[0]);
        URI location = URI.create(this.baseUrl + "notification/read/" + notification.getId() + ".json");
        return Response.created((URI)location).header("org.apache.syncope.resource.id", (Object)notification.getId()).build();
    }

    public void delete(Long notificationId) {
        this.getRestTemplate().getForObject(this.baseUrl + "notification/delete/{notificationId}.json", NotificationTO.class, new Object[]{notificationId});
    }

    public List<NotificationTO> list() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "notification/list.json", NotificationTO[].class, new Object[0]));
    }

    public NotificationTO read(Long notificationId) {
        return (NotificationTO)this.getRestTemplate().getForObject(this.baseUrl + "notification/read/{notificationId}.json", NotificationTO.class, new Object[]{notificationId});
    }

    public void update(Long notificationId, NotificationTO notificationTO) {
        this.getRestTemplate().postForObject(this.baseUrl + "notification/update.json", (Object)notificationTO, NotificationTO.class, new Object[0]);
    }
}

