/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.services.proxy;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import org.apache.syncope.client.services.proxy.SpringServiceProxy;
import org.apache.syncope.common.services.LoggerService;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.to.LoggerTO;
import org.apache.syncope.common.types.AuditLoggerName;
import org.apache.syncope.common.types.LoggerType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.springframework.web.client.RestTemplate;

public class LoggerServiceProxy
extends SpringServiceProxy
implements LoggerService {
    public LoggerServiceProxy(String baseUrl, RestTemplate restTemplate) {
        super(baseUrl, restTemplate);
    }

    public List<LoggerTO> list(LoggerType type) {
        switch (type) {
            case NORMAL: {
                return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "logger/log/list", LoggerTO[].class, new Object[0]));
            }
            case AUDIT: {
                List<Object> auditNames = Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "logger/audit/list", AuditLoggerName[].class, new Object[0]));
                return CollectionWrapper.unwrapLogger(auditNames);
            }
        }
        throw new BadRequestException();
    }

    public LoggerTO read(LoggerType type, String name) {
        List<LoggerTO> logger = this.list(type);
        for (LoggerTO l : logger) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        throw new NotFoundException();
    }

    public void update(LoggerType type, String name, LoggerTO logger) {
        switch (type) {
            case NORMAL: {
                this.getRestTemplate().postForObject(this.baseUrl + "logger/log/{name}/{level}", null, LoggerTO.class, new Object[]{name, logger.getLevel()});
                break;
            }
            case AUDIT: {
                try {
                    this.getRestTemplate().put(this.baseUrl + "logger/audit/enable", (Object)AuditLoggerName.fromLoggerName((String)name), new Object[0]);
                    break;
                }
                catch (Exception e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            default: {
                throw new BadRequestException();
            }
        }
    }

    public void delete(LoggerType type, String name) {
        switch (type) {
            case NORMAL: {
                this.getRestTemplate().getForObject(this.baseUrl + "logger/log/delete/{name}", LoggerTO.class, new Object[]{name});
                break;
            }
            case AUDIT: {
                try {
                    this.getRestTemplate().put(this.baseUrl + "logger/audit/disable", (Object)AuditLoggerName.fromLoggerName((String)name), new Object[0]);
                    break;
                }
                catch (Exception e) {
                    throw new BadRequestException((Throwable)e);
                }
            }
            default: {
                throw new BadRequestException();
            }
        }
    }

    public List<EventCategoryTO> events() {
        return Arrays.asList((Object[])this.getRestTemplate().getForObject(this.baseUrl + "logger/events", EventCategoryTO[].class, new Object[0]));
    }
}

