/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jmx;

import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXInvokerJob
implements Job {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            Object[] params = null;
            String[] types = null;
            String objName = null;
            String objMethod = null;
            JobDataMap jobDataMap = context.getMergedJobDataMap();
            String[] keys = jobDataMap.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                String value = jobDataMap.getString(keys[i]);
                if ("JMX_OBJECTNAME".equalsIgnoreCase(keys[i])) {
                    objName = value;
                    continue;
                }
                if ("JMX_METHOD".equalsIgnoreCase(keys[i])) {
                    objMethod = value;
                    continue;
                }
                if (!"JMX_PARAMDEFS".equalsIgnoreCase(keys[i])) continue;
                String[] paramdefs = this.split(value, ",");
                params = new Object[paramdefs.length];
                types = new String[paramdefs.length];
                block16: for (int k = 0; k < paramdefs.length; ++k) {
                    String[] parts = this.split(paramdefs[k], ":");
                    if (parts.length < 2) {
                        throw new Exception("Invalid parameter definition: required parts missing " + paramdefs[k]);
                    }
                    switch (parts[0].charAt(0)) {
                        case 'i': {
                            params[k] = Integer.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Integer.TYPE.getName();
                            continue block16;
                        }
                        case 'I': {
                            params[k] = Integer.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Integer.class.getName();
                            continue block16;
                        }
                        case 'l': {
                            params[k] = Long.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Long.TYPE.getName();
                            continue block16;
                        }
                        case 'L': {
                            params[k] = Long.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Long.class.getName();
                            continue block16;
                        }
                        case 'f': {
                            params[k] = Float.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Float.TYPE.getName();
                            continue block16;
                        }
                        case 'F': {
                            params[k] = Float.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Float.class.getName();
                            continue block16;
                        }
                        case 'd': {
                            params[k] = Double.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Double.TYPE.getName();
                            continue block16;
                        }
                        case 'D': {
                            params[k] = Double.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Double.class.getName();
                            continue block16;
                        }
                        case 's': {
                            params[k] = jobDataMap.getString(parts[1]);
                            types[k] = String.class.getName();
                            continue block16;
                        }
                        case 'b': {
                            params[k] = Boolean.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Boolean.TYPE.getName();
                            continue block16;
                        }
                        case 'B': {
                            params[k] = Boolean.valueOf(jobDataMap.getString(parts[1]));
                            types[k] = Boolean.class.getName();
                        }
                    }
                }
            }
            if (objName == null || objMethod == null) {
                throw new Exception("Required parameters missing");
            }
            context.setResult(this.invoke(objName, objMethod, params, types));
        }
        catch (Exception e) {
            String m = "Caught a " + e.getClass().getName() + " exception : " + e.getMessage();
            this.getLog().error(m, (Throwable)e);
            throw new JobExecutionException(m, e, false);
        }
    }

    private String[] split(String str, String splitStr) {
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer strTok = new StringTokenizer(str, splitStr);
        while (strTok.hasMoreTokens()) {
            String tok = strTok.nextToken();
            l.add(tok);
        }
        return l.toArray(new String[l.size()]);
    }

    private Object invoke(String objectName, String method, Object[] params, String[] types) throws Exception {
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        ObjectName mbean = new ObjectName(objectName);
        if (server == null) {
            throw new Exception("Can't find mbean server");
        }
        this.getLog().info("invoking " + method);
        return server.invoke(mbean, method, params, types);
    }

    protected Logger getLog() {
        return this.log;
    }
}

