/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.pipeline.components.sax.neko;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXGenerator;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NekoGenerator
extends AbstractSAXGenerator {
    private static final String BALANCE_TAGS_URI = "http://cyberneko.org/html/features/balance-tags";
    private static final String ELEMS_URI = "http://cyberneko.org/html/properties/names/elems";
    private static final String OVERRIDE_NAMESPACES_URI = "http://cyberneko.org/html/features/override-namespaces";
    private static final String INSERT_NAMESPACES_URI = "http://cyberneko.org/html/features/insert-namespaces";
    private static final String NAMESPACES_URI = "http://cyberneko.org/html/properties/namespaces-uri";
    private static final String XHTML_URL = "http://www.w3.org/1999/xhtml";
    private URL htmlSource;
    private SAXParser saxParser;

    public NekoGenerator() {
    }

    public NekoGenerator(URL htmlSource) {
        this.setHtmlSource(htmlSource);
    }

    public void execute() {
        this.saxParser.setContentHandler((ContentHandler)this.getSAXConsumer());
        try {
            this.saxParser.parse(this.htmlSource.toExternalForm());
        }
        catch (SAXException e) {
            throw new ProcessingException("Fatal XML error", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("Fatal protocol violation", (Throwable)e);
        }
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        super.setConfiguration(configuration);
        this.setHtmlSource((URL)configuration.get("source"));
    }

    public void setHtmlSource(URL htmlSource) {
        this.htmlSource = htmlSource;
    }

    public void setup(Map<String, Object> parameters) {
        super.setup(parameters);
        this.saxParser = new SAXParser();
        try {
            this.saxParser.setFeature(BALANCE_TAGS_URI, true);
            this.saxParser.setProperty(ELEMS_URI, (Object)"lower");
            this.saxParser.setFeature(OVERRIDE_NAMESPACES_URI, true);
            this.saxParser.setFeature(INSERT_NAMESPACES_URI, true);
            this.saxParser.setProperty(NAMESPACES_URI, (Object)XHTML_URL);
        }
        catch (SAXNotRecognizedException e) {
            throw new SetupException("Impossible to set property to HTML Parser", (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new SetupException("Property not supported by the HTML Parser", (Throwable)e);
        }
    }

    public String toString() {
        return StringRepresentation.buildString((Object)((Object)this), (String[])new String[]{"htmlSource=" + this.htmlSource});
    }
}

