/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class ColorSpaceCache {
    private static Log log = LogFactory.getLog(ColorSpaceCache.class);
    private URIResolver resolver;
    private Map<String, ColorSpace> colorSpaceMap = Collections.synchronizedMap(new HashMap());

    public ColorSpaceCache(URIResolver resolver) {
        this.resolver = resolver;
    }

    public ColorSpace get(String profileName, String base, String iccProfileSrc, RenderingIntent renderingIntent) {
        String key = profileName + ":" + base + iccProfileSrc;
        ColorSpace colorSpace = null;
        if (!this.colorSpaceMap.containsKey(key)) {
            try {
                ICC_Profile iccProfile = null;
                Source src = this.resolver.resolve(iccProfileSrc, base);
                if (src != null && src instanceof StreamSource) {
                    iccProfile = ColorProfileUtil.getICC_Profile((InputStream)((StreamSource)src).getInputStream());
                }
                if (iccProfile != null) {
                    colorSpace = new ICCColorSpaceWithIntent(iccProfile, renderingIntent, profileName, iccProfileSrc);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (colorSpace != null) {
                this.colorSpaceMap.put(key, colorSpace);
            } else {
                log.warn((Object)("Color profile '" + iccProfileSrc + "' not found."));
            }
        } else {
            colorSpace = this.colorSpaceMap.get(key);
        }
        return colorSpace;
    }
}

