/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.xmlgraphics.util.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AreaTreeObject
implements Cloneable {
    protected Map<QName, String> foreignAttributes = null;
    protected List<ExtensionAttachment> extensionAttachments = null;

    public Object clone() throws CloneNotSupportedException {
        AreaTreeObject ato = (AreaTreeObject)super.clone();
        if (this.foreignAttributes != null) {
            ato.foreignAttributes = (Map)((HashMap)this.foreignAttributes).clone();
        }
        if (this.extensionAttachments != null) {
            ato.extensionAttachments = (List)((ArrayList)this.extensionAttachments).clone();
        }
        return ato;
    }

    public void setForeignAttribute(QName name, String value) {
        if (this.foreignAttributes == null) {
            this.foreignAttributes = new HashMap<QName, String>();
        }
        this.foreignAttributes.put(name, value);
    }

    public void setForeignAttributes(Map<QName, String> atts) {
        if (atts == null || atts.size() == 0) {
            return;
        }
        for (Map.Entry<QName, String> e : atts.entrySet()) {
            this.setForeignAttribute(e.getKey(), e.getValue());
        }
    }

    public String getForeignAttributeValue(QName name) {
        if (this.foreignAttributes != null) {
            return this.foreignAttributes.get(name);
        }
        return null;
    }

    public Map<QName, String> getForeignAttributes() {
        if (this.foreignAttributes != null) {
            return Collections.unmodifiableMap(this.foreignAttributes);
        }
        return Collections.emptyMap();
    }

    private void prepareExtensionAttachmentContainer() {
        if (this.extensionAttachments == null) {
            this.extensionAttachments = new ArrayList<ExtensionAttachment>();
        }
    }

    public void addExtensionAttachment(ExtensionAttachment attachment) {
        this.prepareExtensionAttachmentContainer();
        this.extensionAttachments.add(attachment);
    }

    public void setExtensionAttachments(List<ExtensionAttachment> extensionAttachments) {
        this.prepareExtensionAttachmentContainer();
        this.extensionAttachments.addAll(extensionAttachments);
    }

    public List<ExtensionAttachment> getExtensionAttachments() {
        if (this.extensionAttachments != null) {
            return Collections.unmodifiableList(this.extensionAttachments);
        }
        return Collections.emptyList();
    }

    public boolean hasExtensionAttachments() {
        return this.extensionAttachments != null && !this.extensionAttachments.isEmpty();
    }
}

