/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;

public class TransactionalCache
implements Cache {
    private Cache delegate;
    private boolean clearOnCommit;
    private Map<Object, AddEntry> entriesToAddOnCommit;
    private Map<Object, RemoveEntry> entriesToRemoveOnCommit;

    public TransactionalCache(Cache delegate) {
        this.delegate = delegate;
        this.clearOnCommit = false;
        this.entriesToAddOnCommit = new HashMap<Object, AddEntry>();
        this.entriesToRemoveOnCommit = new HashMap<Object, RemoveEntry>();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public Object getObject(Object key) {
        return this.delegate.getObject(key);
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    @Override
    public void putObject(Object key, Object object) {
        this.entriesToRemoveOnCommit.remove(key);
        this.entriesToAddOnCommit.put(key, new AddEntry(this.delegate, key, object));
    }

    @Override
    public Object removeObject(Object key) {
        this.entriesToAddOnCommit.remove(key);
        this.entriesToRemoveOnCommit.put(key, new RemoveEntry(this.delegate, key));
        return this.delegate.getObject(key);
    }

    @Override
    public void clear() {
        this.reset();
        this.clearOnCommit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        this.delegate.getReadWriteLock().writeLock().lock();
        try {
            if (this.clearOnCommit) {
                this.delegate.clear();
            } else {
                for (RemoveEntry removeEntry : this.entriesToRemoveOnCommit.values()) {
                    removeEntry.commit();
                }
            }
            for (AddEntry addEntry : this.entriesToAddOnCommit.values()) {
                addEntry.commit();
            }
            this.reset();
        }
        finally {
            this.delegate.getReadWriteLock().writeLock().unlock();
        }
    }

    public void rollback() {
        this.reset();
    }

    private void reset() {
        this.clearOnCommit = false;
        this.entriesToRemoveOnCommit.clear();
        this.entriesToAddOnCommit.clear();
    }

    private static class RemoveEntry {
        private Cache cache;
        private Object key;

        public RemoveEntry(Cache cache, Object key) {
            this.cache = cache;
            this.key = key;
        }

        public void commit() {
            this.cache.removeObject(this.key);
        }
    }

    private static class AddEntry {
        private Cache cache;
        private Object key;
        private Object value;

        public AddEntry(Cache cache, Object key, Object value) {
            this.cache = cache;
            this.key = key;
            this.value = value;
        }

        public void commit() {
            this.cache.putObject(this.key, this.value);
        }
    }
}

