/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.types;

import java.text.ParseException;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.AbstractBaseBean;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.types.SyncopeLoggerType;
import org.apache.syncope.common.util.LoggerEventUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlType
@XmlRootElement
public class AuditLoggerName
extends AbstractBaseBean {
    private static final long serialVersionUID = -647989486671786839L;
    private static Logger LOG = LoggerFactory.getLogger(AuditLoggerName.class);
    private final AuditElements.EventCategoryType type;
    private final String category;
    private final String subcategory;
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    private final String event;
    private final AuditElements.Result result;

    @JsonCreator
    public AuditLoggerName(@JsonProperty(value="type") AuditElements.EventCategoryType type, @JsonProperty(value="category") String category, @JsonProperty(value="subcategory") String subcategory, @JsonProperty(value="event") String event, @JsonProperty(value="result") AuditElements.Result result) throws IllegalArgumentException {
        this.type = type == null ? AuditElements.EventCategoryType.CUSTOM : type;
        this.category = category;
        this.subcategory = subcategory;
        this.event = event;
        this.result = result == null ? AuditElements.Result.SUCCESS : result;
    }

    public AuditElements.EventCategoryType getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public String getCategory() {
        return this.category;
    }

    public AuditElements.Result getResult() {
        return this.result;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public String toLoggerName() {
        return SyncopeLoggerType.AUDIT.getPrefix() + '.' + LoggerEventUtils.buildEvent(this.type, this.category, this.subcategory, this.event, this.result);
    }

    public static AuditLoggerName fromLoggerName(String loggerName) throws IllegalArgumentException, ParseException {
        if (StringUtils.isBlank((CharSequence)loggerName)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        if (!loggerName.startsWith(SyncopeLoggerType.AUDIT.getPrefix())) {
            throw new ParseException("Audit logger name must start with " + SyncopeLoggerType.AUDIT.getPrefix(), 0);
        }
        Map.Entry<EventCategoryTO, AuditElements.Result> eventCategory = LoggerEventUtils.parseEventCategory(loggerName.replaceAll(SyncopeLoggerType.AUDIT.getPrefix() + ".", ""));
        LOG.debug("From logger name {} to event category {}", (Object)loggerName, eventCategory);
        return new AuditLoggerName(eventCategory.getKey().getType(), eventCategory.getKey().getCategory(), eventCategory.getKey().getSubcategory(), eventCategory.getKey().getEvents().isEmpty() ? "" : eventCategory.getKey().getEvents().iterator().next(), eventCategory.getValue());
    }
}

