/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.util.iterator.AbstractHierarchyIterator;
import org.apache.wicket.util.iterator.IteratorFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;

public abstract class AbstractHierarchyIteratorWithFilter<N, I extends N>
extends AbstractHierarchyIterator<N, I> {
    private List<IteratorFilter<N>> filters;
    private List<IteratorFilter<N>> traverseFilter;

    public AbstractHierarchyIteratorWithFilter(N root) {
        super(root);
    }

    @Override
    protected final boolean onFilter(N node) {
        if (this.filters != null) {
            for (IteratorFilter<N> filter : this.filters) {
                if (filter.onFilter(node)) continue;
                return false;
            }
        }
        return true;
    }

    public final List<IteratorFilter<N>> getFilters() {
        if (this.filters == null) {
            this.filters = Generics.newArrayList();
        }
        return this.filters;
    }

    public AbstractHierarchyIteratorWithFilter<N, I> addFilter(IteratorFilter<N> filter) {
        Args.notNull(filter, (String)"filter");
        this.getFilters().add(filter);
        return this;
    }

    public Collection<IteratorFilter<N>> replaceFilterSet(Collection<IteratorFilter<N>> filters) {
        List<IteratorFilter<N>> old = this.filters;
        this.filters = null;
        if (filters != null && !filters.isEmpty()) {
            for (IteratorFilter<N> filter : filters) {
                this.addFilter(filter);
            }
        }
        return old;
    }

    public final I getFirst(boolean throwException) {
        if (this.hasNext()) {
            return this.next();
        }
        if (throwException) {
            throw new IllegalStateException("Iterator did not match any component");
        }
        return null;
    }

    public final List<I> toList() {
        ArrayList list = Generics.newArrayList();
        for (Object component : this) {
            list.add(component);
        }
        return list;
    }

    public final List<IteratorFilter<N>> getTraverseFilters() {
        if (this.traverseFilter == null) {
            this.traverseFilter = Generics.newArrayList();
        }
        return this.traverseFilter;
    }

    public AbstractHierarchyIteratorWithFilter<N, I> addTraverseFilters(IteratorFilter<N> filter) {
        this.getTraverseFilters().add(filter);
        return this;
    }

    @Override
    protected boolean onTraversalFilter(N node) {
        if (this.traverseFilter != null) {
            for (IteratorFilter<N> filter : this.traverseFilter) {
                if (filter.onFilter(node)) continue;
                return false;
            }
        }
        return true;
    }
}

